/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class DLTKSearchEditorOpener {
    private ReusedEditorWatcher fReusedEditorWatcher;

    public IEditorPart openElement(Object element) throws PartInitException, ModelException {
        IWorkbenchPage wbPage = DLTKUIPlugin.getActivePage();
        IEditorPart editor = NewSearchUI.reuseEditor() ? this.showWithReuse(element, wbPage) : this.showWithoutReuse(element, wbPage);
        if (element instanceof IModelElement) {
            EditorUtility.revealInEditor(editor, (IModelElement)element);
        }
        return editor;
    }

    public IEditorPart openMatch(Match match) throws PartInitException, ModelException {
        Object element = this.getElementToOpen(match);
        return this.openElement(element);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object element, IWorkbenchPage wbPage) throws PartInitException, ModelException {
        return EditorUtility.openInEditor(element, false);
    }

    private IEditorPart showWithReuse(Object element, IWorkbenchPage wbPage) throws ModelException, PartInitException {
        IFile file;
        if (element instanceof IModelElement) {
            IModelElement module = ((IModelElement)element).getAncestor(5);
            if (module instanceof IExternalSourceModule) {
                String editorID = this.getEditorID(module);
                return this.showInEditor(wbPage, new ExternalStorageEditorInput((IStorage)((IExternalSourceModule)module)), editorID);
            }
            if (module instanceof SourceModule) {
                String editorID = this.getEditorID(module);
                IFile file2 = this.getFile(element);
                return this.showInEditor(wbPage, (IEditorInput)new FileEditorInput(file2), editorID);
            }
        }
        if ((file = this.getFile(element)) != null) {
            String editorID = this.getEditorID(file);
            return this.showInEditor(wbPage, (IEditorInput)new FileEditorInput(file), editorID);
        }
        return null;
    }

    private IFile getFile(Object element) throws ModelException {
        IModelElement jElement;
        ISourceModule cu;
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof IModelElement && (cu = (ISourceModule)(jElement = (IModelElement)element).getAncestor(5)) != null) {
            return (IFile)cu.getCorrespondingResource();
        }
        return null;
    }

    private String getEditorID(IFile file) throws PartInitException {
        Object desc = null;
        if (desc == null) {
            return DLTKUIPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private String getEditorID(IModelElement module) throws PartInitException {
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit(module);
        String editorId = toolkit.getEditorId(module);
        IEditorDescriptor desc = null;
        if (editorId != null) {
            desc = DLTKUIPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor(editorId);
        }
        if (desc == null) {
            return DLTKUIPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IEditorInput input, String editorId) {
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        } else {
            boolean showsSameInputType;
            IEditorPart reusedEditor = this.getReusedEditor();
            boolean isOpen = false;
            if (reusedEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    boolean bl = isOpen = reusedEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !reusedEditor.isDirty() && !this.isPinned(reusedEditor);
            boolean bl = showsSameInputType = reusedEditor != null && reusedEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(reusedEditor, false);
                this.setReusedEditor(null);
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)reusedEditor).setInput(input);
                page.bringToTop((IWorkbenchPart)reusedEditor);
                editor = reusedEditor;
            } else {
                try {
                    editor = page.openEditor(input, editorId, false);
                    if (editor instanceof IReusableEditor) {
                        this.setReusedEditor(editor);
                    } else {
                        this.setReusedEditor(null);
                    }
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openError((Shell)DLTKUIPlugin.getActiveWorkbenchShell(), (String)SearchMessages.Search_Error_openEditor_title, (String)SearchMessages.Search_Error_openEditor_message);
                    return null;
                }
            }
        }
        return editor;
    }

    private IEditorPart getReusedEditor() {
        if (this.fReusedEditorWatcher != null) {
            return this.fReusedEditorWatcher.getReusedEditor();
        }
        return null;
    }

    private void setReusedEditor(IEditorPart editor) {
        if (this.fReusedEditorWatcher == null) {
            this.fReusedEditorWatcher = new ReusedEditorWatcher();
        }
        this.fReusedEditorWatcher.initialize(editor);
    }

    private static class ReusedEditorWatcher
    implements IPartListener {
        private IEditorPart fReusedEditor = null;
        private IPartService fPartService = null;

        public IEditorPart getReusedEditor() {
            return this.fReusedEditor;
        }

        public void initialize(IEditorPart editor) {
            if (this.fReusedEditor != null) {
                this.fPartService.removePartListener((IPartListener)this);
            }
            this.fReusedEditor = editor;
            if (editor != null) {
                this.fPartService = editor.getSite().getWorkbenchWindow().getPartService();
                this.fPartService.addPartListener((IPartListener)this);
            } else {
                this.fPartService = null;
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == this.fReusedEditor) {
                this.initialize(null);
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    }
}

