/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.testing.launcher.DLTKTestingMigrationDelegate;
import org.eclipse.dltk.ruby.testing.internal.Messages;
import org.eclipse.dltk.testing.ITestingEngine;
import org.eclipse.dltk.testing.TestingEngineDetectResult;
import org.eclipse.dltk.testing.TestingEngineManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RubyTestingLaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        ISourceModule element = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)editor.getEditorInput());
        if (element != null) {
            this.launch(new Object[]{element}, mode);
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).toArray(), mode);
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private void launch(Object[] elements, String mode) {
        try {
            IModelElement elementToLaunch = null;
            if (elements.length == 1) {
                Object selected = elements[0];
                if (selected instanceof IFolder) {
                    this.performLaunch((IFolder)selected, mode);
                    return;
                }
                if (!(selected instanceof IModelElement) && selected instanceof IAdaptable) {
                    selected = ((IAdaptable)selected).getAdapter(IModelElement.class);
                }
                if (selected instanceof IModelElement) {
                    IModelElement element = (IModelElement)selected;
                    switch (element.getElementType()) {
                        case 2: {
                            IProject project = ((IScriptProject)element).getProject();
                            ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
                            IFolder specFolder = project.getFolder("test");
                            if (specFolder != null && specFolder.exists()) {
                                configs.add(this.findOrCreateLaunch(specFolder, mode));
                            }
                            if ((specFolder = project.getFolder("spec")) != null && specFolder.exists()) {
                                configs.add(this.findOrCreateLaunch(specFolder, mode));
                            }
                            ILaunchConfiguration config = null;
                            if (configs.size() == 1) {
                                config = (ILaunchConfiguration)configs.get(0);
                            } else if (configs.size() > 1) {
                                config = this.chooseConfiguration(configs, mode);
                            }
                            if (config != null) {
                                if (config.getAttribute("org.eclipse.dltk.testing.engineId", null) == null) {
                                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RubyTestingLaunchShortcut_testLaunch, (String)Messages.RubyTestingLaunchShortcut_theSelectedLaunchConfigurationDoesntHaveATestingEngineConfigured);
                                    return;
                                }
                                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                            }
                            return;
                        }
                        case 3: 
                        case 4: {
                            this.performLaunch((IFolder)element.getResource(), mode);
                            return;
                        }
                        case 5: 
                        case 7: 
                        case 9: {
                            elementToLaunch = element;
                        }
                    }
                }
            }
            if (elementToLaunch == null) {
                this.showNoTestsFoundDialog();
                return;
            }
            this.performLaunch(elementToLaunch, mode);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)Messages.RubyTestingLaunchShortcut_testLaunch, (String)Messages.RubyTestingLaunchShortcut_testLaunchUnexpectedlyFailed);
        }
    }

    private void showNoTestsFoundDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RubyTestingLaunchShortcut_testLaunch, (String)Messages.RubyTestingLaunchShortcut_unableToLocateAnyTestsInTheSpecifiedSelection);
    }

    private void performLaunch(IModelElement element, String mode) throws InterruptedException, CoreException {
        ILaunchConfigurationWorkingCopy temporary = this.createLaunchConfiguration(element);
        if (temporary == null) {
            return;
        }
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(temporary, mode);
        if (config == null) {
            IResource resource = element.getUnderlyingResource();
            if (resource != null) {
                temporary.setMappedResources(new IResource[]{resource});
            }
            config = temporary.doSave();
        } else {
            config = DLTKTestingMigrationDelegate.fixMappedResources((ILaunchConfiguration)config);
        }
        if (config.getAttribute("org.eclipse.dltk.testing.engineId", null) == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RubyTestingLaunchShortcut_testLaunch, (String)Messages.RubyTestingLaunchShortcut_theSelectedLaunchConfigurationDoesntHaveATestingEngineConfigured);
            return;
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    private ILaunchConfiguration findOrCreateLaunch(IFolder folder, String mode) throws InterruptedException, CoreException {
        String name = folder.getName();
        String testName = name.substring(name.lastIndexOf(47) + 1);
        ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
        final ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(testName));
        wc.setAttribute("project", folder.getProject().getName());
        IModelElement element = DLTKCore.create((IResource)folder);
        if (element != null) {
            wc.setAttribute("org.eclipse.dltk.testing.CONTAINER", element.getHandleIdentifier());
            final ITestingEngine[] engines = TestingEngineManager.getEngines((String)"org.eclipse.dltk.ruby.core.nature");
            element.accept(new IModelElementVisitor(){
                private boolean detected;

                public boolean visit(IModelElement element) {
                    TestingEngineDetectResult detection;
                    if (this.detected) {
                        return false;
                    }
                    if (element instanceof ISourceModule && (detection = TestingEngineManager.detect((ITestingEngine[])engines, (ISourceModule)((ISourceModule)element))) != null) {
                        wc.setAttribute("org.eclipse.dltk.testing.engineId", detection.getEngine().getId());
                        this.detected = true;
                        return false;
                    }
                    return element instanceof IScriptFolder || element instanceof IProjectFragment || element instanceof IScriptProject;
                }
            });
        }
        wc.setAttribute("nature", "org.eclipse.dltk.ruby.core.nature");
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(wc, mode);
        if (config == null) {
            wc.setMappedResources(new IResource[]{folder});
            config = wc.doSave();
        } else {
            config = DLTKTestingMigrationDelegate.fixMappedResources((ILaunchConfiguration)config);
        }
        return config;
    }

    private void performLaunch(IFolder folder, String mode) throws InterruptedException, CoreException {
        ILaunchConfiguration config = this.findOrCreateLaunch(folder, mode);
        if (config.getAttribute("org.eclipse.dltk.testing.engineId", null) == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RubyTestingLaunchShortcut_testLaunch, (String)Messages.RubyTestingLaunchShortcut_theSelectedLaunchConfigurationDoesntHaveATestingEngineConfigured);
            return;
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    private Shell getShell() {
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) throws InterruptedException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.RubyTestingLaunchShortcut_selectTestConfiguration);
        if (mode.equals("debug")) {
            dialog.setMessage(Messages.RubyTestingLaunchShortcut_selectConfigurationToDebug);
        } else {
            dialog.setMessage(Messages.RubyTestingLaunchShortcut_selectConfigurationToRun);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    protected String getLaunchConfigurationTypeId() {
        return "org.eclipse.dltk.ruby.testing.launchConfig";
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IModelElement element) throws CoreException {
        String testFileName;
        String name = ScriptElementLabels.getDefault().getTextLabel((Object)element, 65536L);
        String testName = name.substring(name.lastIndexOf(47) + 1);
        switch (element.getElementType()) {
            case 5: 
            case 7: {
                testFileName = element.getResource().getProjectRelativePath().toPortableString();
                break;
            }
            case 9: {
                testFileName = element.getResource().getProjectRelativePath().toPortableString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid element type to create a launch configuration: " + element.getClass().getName());
            }
        }
        ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(testName));
        wc.setAttribute("project", element.getScriptProject().getElementName());
        wc.setAttribute("mainScript", testFileName);
        wc.setAttribute("nature", "org.eclipse.dltk.ruby.core.nature");
        wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", "true");
        ITestingEngine[] engines = TestingEngineManager.getEngines((String)"org.eclipse.dltk.ruby.core.nature");
        ISourceModule module = (ISourceModule)element.getAncestor(5);
        TestingEngineDetectResult detection = TestingEngineManager.detect((ITestingEngine[])engines, (ISourceModule)module);
        if (detection != null) {
            wc.setAttribute("org.eclipse.dltk.testing.engineId", detection.getEngine().getId());
        }
        return wc;
    }

    protected String[] getAttributeNamesToCompare() {
        return new String[]{"project", "org.eclipse.dltk.testing.CONTAINER", "mainScript", "nature"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSameAttributes(ILaunchConfiguration config1, ILaunchConfiguration config2, String[] attributeToCompare) {
        try {
            int i = 0;
            while (true) {
                String val2;
                if (i >= attributeToCompare.length) {
                    return true;
                }
                String val1 = config1.getAttribute(attributeToCompare[i], "");
                if (!val1.equals(val2 = config2.getAttribute(attributeToCompare[i], ""))) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private ILaunchConfiguration findExistingLaunchConfiguration(ILaunchConfigurationWorkingCopy temporary, String mode) throws InterruptedException, CoreException {
        ILaunchConfiguration config;
        ILaunchConfigurationType configType = temporary.getType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        String[] attributeToCompare = this.getAttributeNamesToCompare();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            config = configs[i];
            if (RubyTestingLaunchShortcut.hasSameAttributes(config, (ILaunchConfiguration)temporary, attributeToCompare)) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 0) {
            return null;
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }
}

