/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.console.ui;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public abstract class AbstractPulldownAction
implements IWorkbenchWindowPulldownDelegate2 {
    private Menu fMenu;
    private IAction fAction;
    protected boolean fRecreateMenu = false;

    private void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void addToMenu(Menu menu, IAction action) {
        action.setText(action.getText());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    private void initialize(IAction action) {
        this.setAction(action);
        this.updateTooltip();
    }

    protected void updateTooltip() {
    }

    public void dispose() {
        this.setMenu(null);
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    private void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (AbstractPulldownAction.this.fRecreateMenu) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    AbstractPulldownAction.this.fillMenu(m);
                    AbstractPulldownAction.this.fRecreateMenu = false;
                }
            }
        });
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    protected abstract void fillMenu(Menu var1);

    protected void addSeparator(Menu menu) {
        new MenuItem(menu, 2);
    }

    protected Menu addSubmenu(Menu menu, String text) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(text);
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        return menu2;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.initialize(action);
        }
    }

    public void init(IWorkbenchWindow window) {
    }
}

