/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter;

import java.net.URL;
import java.util.Map;
import org.eclipse.dltk.formatter.AbstractScriptFormatterFactory;
import org.eclipse.dltk.ruby.formatter.RubyFormatter;
import org.eclipse.dltk.ruby.formatter.preferences.RubyFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.preferences.PreferenceKey;

public class RubyFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final String[] KEYS = new String[]{"formatter.tabulation.char", "formatter.indentation.size", "formatter.tabulation.size", "indent.class", "indent.module", "indent.method", "indent.blocks", "indent.if", "indent.case", "indent.when", "line.file.require.after", "line.file.module.between", "line.file.class.between", "line.file.method.between", "line.first.before", "line.module.before", "line.class.before", "line.method.before", "lines.preserve", "wrap.comments", "wrap.comments.length"};

    public PreferenceKey getProfilesKey() {
        return new PreferenceKey("org.eclipse.dltk.ruby.formatter", "formatter.profiles");
    }

    public PreferenceKey getActiveProfileKey() {
        return new PreferenceKey("org.eclipse.dltk.ruby.formatter", "formatter.profiles.active");
    }

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] result = new PreferenceKey[KEYS.length];
        int i = 0;
        while (i < KEYS.length) {
            String key = KEYS[i];
            String qualifier = "formatter.tabulation.char".equals(key) || "formatter.indentation.size".equals(key) || "formatter.tabulation.size".equals(key) ? "org.eclipse.dltk.ruby.ui" : "org.eclipse.dltk.ruby.formatter";
            result[i] = new PreferenceKey(qualifier, key);
            ++i;
        }
        return result;
    }

    public IScriptFormatter createFormatter(String lineDelimiter, Map<String, String> preferences) {
        return new RubyFormatter(lineDelimiter, preferences);
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource("formatterPreview.rb");
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new RubyFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }
}

