/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.index.lucene.LucenePlugin;
import org.eclipse.dltk.internal.core.index.lucene.IndexDirectory;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;

class IndexContainer {
    private static final String TIMESTAMPS_DIR = "timestamps";
    private final String fIndexRoot;
    private final String fContainerId;
    private IndexWriter fTimestampsWriter;
    private SearcherManager fTimestampsSearcher;
    private Map<IndexType, Map<Integer, IndexWriter>> fIndexWriters;
    private Map<IndexType, Map<Integer, SearcherManager>> fIndexSearchers;

    public IndexContainer(String indexRoot, String containerId) {
        this.fIndexRoot = indexRoot;
        this.fContainerId = containerId;
        this.initialize();
    }

    private void initialize() {
        this.fIndexWriters = new HashMap<IndexType, Map<Integer, IndexWriter>>();
        this.fIndexWriters.put(IndexType.DECLARATIONS, new HashMap());
        this.fIndexWriters.put(IndexType.REFERENCES, new HashMap());
        this.fIndexSearchers = new HashMap<IndexType, Map<Integer, SearcherManager>>();
        this.fIndexSearchers.put(IndexType.DECLARATIONS, new HashMap());
        this.fIndexSearchers.put(IndexType.REFERENCES, new HashMap());
    }

    public final String getId() {
        return this.fContainerId;
    }

    public synchronized IndexWriter getTimestampsWriter() {
        if (this.fTimestampsWriter == null) {
            try {
                IndexDirectory indexDir = new IndexDirectory(Paths.get(this.fIndexRoot, this.fContainerId, TIMESTAMPS_DIR));
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)new SimpleAnalyzer());
                config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                this.fTimestampsWriter = new IndexWriter((Directory)indexDir, config);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return this.fTimestampsWriter;
    }

    public synchronized SearcherManager getTimestampsSearcher() {
        try {
            if (this.fTimestampsSearcher == null) {
                this.fTimestampsSearcher = new SearcherManager(this.getTimestampsWriter(), true, new SearcherFactory());
            }
            this.fTimestampsSearcher.maybeRefresh();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        return this.fTimestampsSearcher;
    }

    public synchronized IndexWriter getIndexWriter(IndexType dataType, int elementType) {
        IndexWriter writer = this.fIndexWriters.get((Object)dataType).get(elementType);
        if (writer == null) {
            try {
                IndexDirectory indexDir = new IndexDirectory(Paths.get(this.fIndexRoot, this.fContainerId, dataType.getDirectory(), String.valueOf(elementType)));
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)new SimpleAnalyzer());
                config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                writer = new IndexWriter((Directory)indexDir, config);
                this.fIndexWriters.get((Object)dataType).put(elementType, writer);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return writer;
    }

    public synchronized SearcherManager getIndexSearcher(IndexType dataType, int elementType) {
        SearcherManager searcher = this.fIndexSearchers.get((Object)dataType).get(elementType);
        try {
            if (searcher == null) {
                searcher = new SearcherManager(this.getIndexWriter(dataType, elementType), true, new SearcherFactory());
                this.fIndexSearchers.get((Object)dataType).put(elementType, searcher);
            }
            searcher.maybeRefresh();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        return searcher;
    }

    public synchronized void delete(String sourceModule) {
        Term term = new Term("path", sourceModule);
        try {
            this.getTimestampsWriter().deleteDocuments(new Term[]{term});
            for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
                for (IndexWriter writer : dataWriters.values()) {
                    writer.deleteDocuments(new Term[]{term});
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public synchronized void delete() {
        new IndexCleaner().schedule();
    }

    public synchronized void close() {
        try {
            if (this.fTimestampsSearcher != null) {
                this.fTimestampsSearcher.close();
            }
            if (this.fTimestampsWriter != null) {
                this.fTimestampsWriter.close();
            }
            for (Map<Integer, SearcherManager> map : this.fIndexSearchers.values()) {
                for (SearcherManager searcherManager : map.values()) {
                    if (searcherManager == null) continue;
                    searcherManager.close();
                }
            }
            for (Map<Integer, SearcherManager> map : this.fIndexWriters.values()) {
                for (IndexWriter indexWriter : map.values()) {
                    if (indexWriter == null) continue;
                    indexWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            Logger.logException(iOException);
        }
    }

    private final class IndexCleaner
    extends Job {
        public IndexCleaner() {
            super("");
            this.setUser(false);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == LucenePlugin.LUCENE_JOB_FAMILY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IndexContainer.this.close();
            Path containerPath = Paths.get(IndexContainer.this.fIndexRoot, IndexContainer.this.getId());
            try {
                Files.walkFileTree(containerPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Logger.logException(e);
            }
            return Status.OK_STATUS;
        }
    }
}

