/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;

public class CompletionVisitor
extends TypeInferencerVisitor {
    private final int position;
    private Stack<Level> levels = new Stack();
    private IValueCollection savedCollection = null;
    private PositionReachedException positionReached = null;

    public CompletionVisitor(ITypeInferenceContext context, int position) {
        super(context);
        this.position = position;
    }

    @Override
    public IValueReference visit(ASTNode node) {
        if (node instanceof FunctionStatement) {
            if (this.levels.isEmpty() && this.positionReached == null && node.sourceStart() >= this.position) {
                return null;
            }
            return super.visit(node);
        }
        IValueReference result = super.visit(node);
        if (!this.levels.isEmpty() && this.levels.peek().enabled) {
            return result;
        }
        if (this.savedCollection == null && node.sourceEnd() > this.position) {
            this.savedCollection = this.peekContext();
            throw new PositionReachedException(node, result);
        }
        return result;
    }

    @Override
    public IValueReference visitFunctionStatement(FunctionStatement node) {
        IValueReference result;
        Level level = new Level();
        level.enabled = node.sourceEnd() < this.position || node.sourceStart() > this.position;
        this.levels.push(level);
        try {
            result = super.visitFunctionStatement(node);
        }
        finally {
            this.levels.pop();
        }
        return result;
    }

    @Override
    public void visitFunctionBody(FunctionStatement node) {
        try {
            super.visitFunctionBody(node);
        }
        catch (PositionReachedException e) {
            this.positionReached = e;
        }
    }

    @Override
    public IValueCollection getCollection() {
        if (this.savedCollection != null) {
            return this.savedCollection;
        }
        return super.getCollection();
    }

    static class Level {
        boolean enabled;

        Level() {
        }
    }
}

