/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IDLTKLanguageToolkitExtension;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.index.sql.Container;
import org.eclipse.dltk.core.index.sql.DbFactory;
import org.eclipse.dltk.core.index.sql.Element;
import org.eclipse.dltk.core.index.sql.File;
import org.eclipse.dltk.core.index.sql.IElementHandler;
import org.eclipse.dltk.core.index.sql.SqlIndex;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchEngineExtension;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ArchiveFolder;
import org.eclipse.dltk.internal.core.BuiltinScriptFolder;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;
import org.eclipse.dltk.internal.core.search.DLTKWorkspaceScope;

public class SqlSearchEngine
implements ISearchEngineExtension {
    public void search(int elementType, String qualifier, String elementName, int trueFlags, int falseFlags, int limit, ISearchEngine.SearchFor searchFor, ISearchEngine.MatchRule matchRule, IDLTKSearchScope scope, ISearchRequestor requestor, IProgressMonitor monitor) {
        this.search(elementType, qualifier, elementName, null, trueFlags, falseFlags, limit, searchFor, matchRule, scope, requestor, monitor);
    }

    public void search(int elementType, String qualifier, String elementName, String parent, int trueFlags, int falseFlags, int limit, ISearchEngine.SearchFor searchFor, ISearchEngine.MatchRule matchRule, IDLTKSearchScope scope, ISearchRequestor requestor, IProgressMonitor monitor) {
        try {
            DbFactory dbFactory = DbFactory.getInstance();
            if (dbFactory == null) {
                return;
            }
            Connection connection = dbFactory.createConnection();
            if (connection == null) {
                return;
            }
            try {
                boolean searchForRefs;
                String natureId = scope.getLanguageToolkit().getNatureId();
                ElementHandler elementHandler = new ElementHandler(connection, scope, requestor);
                int[] containersId = null;
                int[] filesId = null;
                if (!(scope instanceof DLTKWorkspaceScope)) {
                    IPath[] containerPaths = scope.enclosingProjectsAndZips();
                    LinkedList<Integer> containerIdsList = new LinkedList<Integer>();
                    IPath[] iPathArray = containerPaths;
                    int n = containerPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath containerPath = iPathArray[n2];
                        Container container = dbFactory.getContainerDao().selectByPath(connection, containerPath.toString());
                        if (container != null) {
                            containerIdsList.add(container.getId());
                        }
                        ++n2;
                    }
                    if (containerIdsList.size() > 0) {
                        containersId = new int[containerIdsList.size()];
                        int i = 0;
                        while (i < containerIdsList.size()) {
                            containersId[i] = (Integer)containerIdsList.get(i);
                            ++i;
                        }
                    }
                    if (scope instanceof DLTKSearchScope) {
                        LinkedList<Integer> fileIdsList = new LinkedList<Integer>();
                        String[] relativePaths = ((DLTKSearchScope)scope).getRelativePaths();
                        String[] fileExtensions = ScriptModelUtil.getFileExtensions((IDLTKLanguageToolkit)scope.getLanguageToolkit());
                        String[] stringArray = relativePaths;
                        int n3 = relativePaths.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String relativePath = stringArray[n4];
                            if (relativePath.length() > 0) {
                                if (fileExtensions != null) {
                                    boolean isScriptFile = false;
                                    String[] stringArray2 = fileExtensions;
                                    int n5 = fileExtensions.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        String ext = stringArray2[n6];
                                        if (relativePath.endsWith("." + ext)) {
                                            isScriptFile = true;
                                            break;
                                        }
                                        ++n6;
                                    }
                                    if (!isScriptFile) break;
                                }
                                for (Integer containerId : containerIdsList) {
                                    File file = dbFactory.getFileDao().select(connection, relativePath, containerId);
                                    if (file == null) continue;
                                    fileIdsList.add(file.getId());
                                }
                            }
                            ++n4;
                        }
                        if (fileIdsList.size() > 0) {
                            filesId = new int[fileIdsList.size()];
                            int i = 0;
                            while (i < fileIdsList.size()) {
                                filesId[i] = (Integer)fileIdsList.get(i);
                                ++i;
                            }
                        }
                    }
                }
                boolean searchForDecls = searchFor == ISearchEngine.SearchFor.DECLARATIONS || searchFor == ISearchEngine.SearchFor.ALL_OCCURENCES;
                boolean bl = searchForRefs = searchFor == ISearchEngine.SearchFor.REFERENCES || searchFor == ISearchEngine.SearchFor.ALL_OCCURENCES;
                if (searchForDecls) {
                    dbFactory.getElementDao().search(connection, elementName, matchRule, elementType, trueFlags, falseFlags, qualifier, parent, filesId, containersId, natureId, limit, false, elementHandler, monitor);
                }
                if (searchForRefs) {
                    dbFactory.getElementDao().search(connection, elementName, matchRule, elementType, trueFlags, falseFlags, qualifier, parent, filesId, containersId, natureId, limit, true, elementHandler, monitor);
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            SqlIndex.error("An exception has thrown while performing a search", e);
        }
    }

    class ElementHandler
    implements IElementHandler,
    ISearchRequestor {
        private static final String EMPTY = "";
        private Map<Integer, File> fileCache = new HashMap<Integer, File>();
        private Map<Integer, Container> containerCache = new HashMap<Integer, Container>();
        private Map<String, IProjectFragment> projectFragmentCache = new HashMap<String, IProjectFragment>();
        private Map<String, ISourceModule> sourceModuleCache = new HashMap<String, ISourceModule>();
        private Connection connection;
        private ISearchRequestor searchRequestor;
        private IDLTKSearchScope scope;

        public ElementHandler(Connection connection, IDLTKSearchScope scope, ISearchRequestor searchRequestor) {
            this.connection = connection;
            this.scope = scope;
            this.searchRequestor = searchRequestor;
        }

        public void handle(Element element) {
            try {
                int containerId;
                Container container;
                DbFactory dbFactory = DbFactory.getInstance();
                int fileId = element.getFileId();
                File file = this.fileCache.get(fileId);
                if (file == null) {
                    file = dbFactory.getFileDao().selectById(this.connection, fileId);
                    if (file == null) {
                        return;
                    }
                    this.fileCache.put(fileId, file);
                }
                if ((container = this.containerCache.get(containerId = file.getContainerId())) == null) {
                    container = dbFactory.getContainerDao().selectById(this.connection, containerId);
                    if (container == null) {
                        return;
                    }
                    this.containerCache.put(containerId, container);
                }
                String containerPath = container.getPath();
                IDLTKLanguageToolkit toolkit = ((DLTKSearchScope)this.scope).getLanguageToolkit();
                if (toolkit instanceof IDLTKLanguageToolkitExtension && ((IDLTKLanguageToolkitExtension)toolkit).isArchiveFileName(containerPath)) {
                    containerPath = String.valueOf(containerPath) + "|";
                }
                if (containerPath.length() != 0 && containerPath.charAt(containerPath.length() - 1) != '/') {
                    containerPath = String.valueOf(containerPath) + '/';
                }
                String filePath = file.getPath();
                String resourcePath = String.valueOf(containerPath) + filePath;
                IProjectFragment projectFragment = this.projectFragmentCache.get(containerPath);
                if (projectFragment == null) {
                    projectFragment = ((DLTKSearchScope)this.scope).projectFragment(resourcePath);
                    if (projectFragment == null) {
                        projectFragment = ((DLTKSearchScope)this.scope).projectFragment(containerPath);
                    }
                    this.projectFragmentCache.put(containerPath, projectFragment);
                }
                if (projectFragment == null) {
                    return;
                }
                String folderPath = EMPTY;
                String fileName = filePath;
                int i = filePath.lastIndexOf(47);
                if (i == -1) {
                    i = filePath.lastIndexOf(92);
                }
                if (i != -1) {
                    folderPath = filePath.substring(0, i);
                    fileName = filePath.substring(i + 1);
                }
                if (!this.scope.encloses(resourcePath)) {
                    return;
                }
                ISourceModule sourceModule = this.sourceModuleCache.get(resourcePath);
                if (sourceModule == null) {
                    if (projectFragment.isArchive()) {
                        ArchiveFolder scriptFolder = new ArchiveFolder((ProjectFragment)projectFragment, (IPath)new Path(folderPath));
                        sourceModule = scriptFolder.getSourceModule(fileName);
                    } else if (projectFragment.isExternal()) {
                        ExternalScriptFolder scriptFolder = new ExternalScriptFolder((ProjectFragment)projectFragment, (IPath)new Path(folderPath));
                        sourceModule = scriptFolder.getSourceModule(fileName);
                    } else if (projectFragment.isBuiltin()) {
                        BuiltinScriptFolder scriptFolder = new BuiltinScriptFolder((ProjectFragment)projectFragment, (IPath)new Path(folderPath));
                        sourceModule = scriptFolder.getSourceModule(fileName);
                    } else {
                        IProject project = projectFragment.getScriptProject().getProject();
                        sourceModule = DLTKCore.createSourceModuleFrom((IFile)project.getFile(filePath));
                    }
                    this.sourceModuleCache.put(resourcePath, sourceModule);
                }
                this.match(element.getType(), element.getFlags(), element.getOffset(), element.getLength(), element.getNameOffset(), element.getNameLength(), element.getName(), element.getMetadata(), element.getDoc(), element.getQualifier(), element.getParent(), sourceModule, element.isReference());
            }
            catch (SQLException e) {
                SqlIndex.error("An exception is thrown while searching elements", e);
            }
        }

        public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
            this.searchRequestor.match(elementType, flags, offset, length, nameOffset, nameLength, elementName, metadata, doc, qualifier, parent, sourceModule, isReference);
        }
    }
}

