/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.structure;

import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.parser.printer.SimpleCodePrinter;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;

public class TclProcessorUtil {
    public static String asString(TclArgument arg) {
        return TclProcessorUtil.asString(arg, true);
    }

    public static String asString(TclArgument arg, boolean unquote) {
        if (arg instanceof StringArgument) {
            int len;
            String value = ((StringArgument)arg).getValue();
            if (unquote && (len = value.length()) >= 2) {
                if (value.charAt(0) == '{' && value.charAt(len - 1) == '}') {
                    return value.substring(1, len - 1);
                }
                if (value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
                    return value.substring(1, len - 1);
                }
            }
            return value;
        }
        return SimpleCodePrinter.getArgumentString((TclArgument)arg, (int)arg.getStart());
    }

    public static ITclModelBuildContext.ITclParserInput asInput(TclArgument arg) {
        if (arg instanceof StringArgument) {
            String source = ((StringArgument)arg).getValue();
            int start = arg.getStart();
            int end = arg.getEnd();
            if (source.startsWith("{") && source.endsWith("}")) {
                source = source.substring(1, source.length() - 1);
                ++start;
                --end;
            } else if (source.startsWith("\"") && source.endsWith("\"")) {
                source = source.substring(1, source.length() - 1);
                ++start;
                --end;
            }
            return new TclParserInput(source, start, end);
        }
        return null;
    }

    private static class TclParserInput
    implements ITclModelBuildContext.ITclParserInput {
        private final String content;
        private final int start;
        private final int end;

        public TclParserInput(String content, int start, int end) {
            this.content = content;
            this.start = start;
            this.end = end;
        }

        public String getContent() {
            return this.content;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

