/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.util.Map;
import org.eclipse.dltk.formatter.IFormatterIndentGenerator;
import org.eclipse.dltk.formatter.internal.FormatterIndentGenerator;
import org.eclipse.dltk.formatter.internal.FormatterMixedIndentGenerator;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractScriptFormatter
implements IScriptFormatter {
    private final Map<String, ? extends Object> preferences;

    protected AbstractScriptFormatter(Map<String, ? extends Object> preferences) {
        this.preferences = preferences;
    }

    protected boolean getBoolean(String key) {
        Object value = this.preferences.get(key);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            return Boolean.valueOf(value.toString());
        }
        return false;
    }

    protected int getInt(String key) {
        return AbstractScriptFormatter.toInt(this.preferences.get(key));
    }

    private static int toInt(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    protected String getString(String key) {
        Object value = this.preferences.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected IFormatterIndentGenerator createIndentGenerator() {
        int tabSize = this.getInt("formatter.tabulation.size");
        int indentSize = this.getInt("formatter.indentation.size");
        String indentType = this.getString("formatter.tabulation.char");
        if ("space".equals(indentType)) {
            return new FormatterIndentGenerator(' ', indentSize, tabSize);
        }
        if ("mixed".equals(indentType)) {
            return new FormatterMixedIndentGenerator(indentSize, tabSize);
        }
        return new FormatterIndentGenerator('\t', 1, tabSize);
    }

    public int detectIndentationLevel(IDocument document, int offset) {
        return 0;
    }
}

