/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.python.parser.ast.expressions.PythonAllImportExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportAsExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonTestListExpression;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonImportFromStatement
extends Statement {
    private Expression fImportExpressions;
    private Expression fModuleExpression;

    public PythonImportFromStatement(DLTKToken t, Expression moduleExpression, Expression importExpressions) {
        super(t);
        this.fModuleExpression = moduleExpression;
        this.fImportExpressions = importExpressions;
    }

    public int getKind() {
        return 37002;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.fModuleExpression != null) {
                this.fModuleExpression.traverse(pVisitor);
            }
            if (this.fImportExpressions != null) {
                this.fImportExpressions.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public String getImportModuleName() {
        if (this.fModuleExpression != null && this.fModuleExpression instanceof SimpleReference) {
            return ((SimpleReference)this.fModuleExpression).getName();
        }
        return "";
    }

    public Map getImportedAsNames() {
        PythonTestListExpression testList;
        List expressions;
        HashMap<String, String> importedAsNames = new HashMap<String, String>();
        if (this.fImportExpressions != null && this.fImportExpressions instanceof PythonTestListExpression && (expressions = (testList = (PythonTestListExpression)this.fImportExpressions).getExpressions()) != null) {
            Iterator i = expressions.iterator();
            while (i.hasNext()) {
                String name;
                Expression exp = (Expression)i.next();
                if (exp instanceof PythonImportExpression && (name = ((PythonImportExpression)exp).getName()) != null) {
                    importedAsNames.put(name, name);
                }
                if (!(exp instanceof PythonImportAsExpression)) continue;
                PythonImportAsExpression importAsExpression = (PythonImportAsExpression)exp;
                String name2 = importAsExpression.getName();
                String asName = importAsExpression.getAsName();
                if (name2 == null || asName == null) continue;
                importedAsNames.put(name2, asName);
            }
        }
        return importedAsNames;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("from ");
        if (this.fModuleExpression != null) {
            this.fModuleExpression.printNode(output);
        }
        output.formatPrintLn(" import ");
        if (this.fImportExpressions != null) {
            this.fImportExpressions.printNode(output);
        }
    }

    public boolean isAllImport() {
        return this.fImportExpressions != null && this.fImportExpressions instanceof PythonAllImportExpression;
    }

    public PositionInformation getPosition() {
        int start = this.sourceStart();
        int end = this.sourceEnd();
        return new PositionInformation(start, end, start, end);
    }
}

