/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.jface.text.IRegion;

public class FormatterDocument
implements IFormatterDocument {
    private final String text;
    private final Map booleans = new HashMap();
    private final Map strings = new HashMap();
    private final Map ints = new HashMap();

    public FormatterDocument(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    @Override
    public String get(int startOffset, int endOffset) {
        return this.text.substring(startOffset, endOffset);
    }

    @Override
    public String get(IRegion region) {
        return this.get(region.getOffset(), region.getOffset() + region.getLength());
    }

    public void setBoolean(String key, boolean value) {
        this.booleans.put(key, value);
    }

    @Override
    public boolean getBoolean(String key) {
        Boolean value = (Boolean)this.booleans.get(key);
        return value != null && value != false;
    }

    public void setString(String key, String value) {
        this.strings.put(key, value);
    }

    @Override
    public String getString(String key) {
        return (String)this.strings.get(key);
    }

    public void setInt(String key, int value) {
        this.ints.put(key, new Integer(value));
    }

    @Override
    public int getInt(String key) {
        Integer value = (Integer)this.ints.get(key);
        return value != null ? value : 0;
    }

    @Override
    public char charAt(int index) {
        return this.text.charAt(index);
    }
}

