/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.internal.javascript.parser.structure.ExpressionNode;
import org.eclipse.dltk.internal.javascript.parser.structure.FieldNode;
import org.eclipse.dltk.internal.javascript.parser.structure.FunctionDeclarationExpressionLike;
import org.eclipse.dltk.internal.javascript.parser.structure.NameNode;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.JSVariable;
import org.eclipse.dltk.javascript.ast.AbstractNavigationVisitor;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.structure.FunctionDeclaration;
import org.eclipse.dltk.javascript.structure.FunctionExpression;
import org.eclipse.dltk.javascript.structure.FunctionNode;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IScope;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureHandler;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.structure.IStructureVisitor;
import org.eclipse.dltk.javascript.structure.ObjectDeclaration;
import org.eclipse.dltk.javascript.structure.PropertyDeclaration;
import org.eclipse.dltk.javascript.structure.ScriptScope;
import org.eclipse.dltk.javascript.structure.VariableNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;

public class StructureReporter3
extends AbstractNavigationVisitor<IStructureNode>
implements IStructureVisitor {
    private final ReferenceSource referenceSource;
    private final Stack<IParentNode> parents = new Stack();
    private final Stack<List<JSDeclaration>> declarations = new Stack();
    private final IStructureHandler[] handlers;
    private JSDocSupport jsdocSupport = new JSDocSupport();
    private final JSProblemReporter fReporter = null;
    private final ITypeChecker fTypeChecker = null;

    public StructureReporter3(ReferenceSource referenceSource) {
        this.referenceSource = referenceSource;
        List<IStructureHandler> extensions = TypeInfoManager.createExtensions(referenceSource, IStructureHandler.class, this);
        this.handlers = extensions.toArray(new IStructureHandler[extensions.size()]);
    }

    public IStructureNode visit(ASTNode node) {
        IStructureHandler[] iStructureHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IStructureHandler handler = iStructureHandlerArray[n2];
            IStructureNode value = handler.handle(node);
            if (value != IStructureHandler.CONTINUE) {
                return this.addToParent(value);
            }
            ++n2;
        }
        return this.addToParent((IStructureNode)super.visit(node));
    }

    private IStructureNode addToParent(@Nullable IStructureNode value) {
        if (value != null && !this.parents.isEmpty()) {
            IParentNode parent = this.parents.peek();
            parent.addToScope(value);
        }
        return value;
    }

    @Override
    public void push(IParentNode declaration) {
        this.parents.push(declaration);
    }

    @Override
    public IParentNode pop() {
        return this.parents.pop();
    }

    @Override
    public IParentNode peek() {
        return this.parents.peek();
    }

    public IStructureNode visitScript(Script node) {
        this.push(new ScriptScope());
        this.declarations.push(node.getDeclarations());
        super.visitScript(node);
        this.declarations.pop();
        return this.pop();
    }

    public IStructureNode visitFunctionStatement(FunctionStatement node) {
        JSMethod method = new JSMethod(node, this.referenceSource);
        this.jsdocSupport.processMethod(node, method, this.fReporter, this.fTypeChecker);
        FunctionNode functionNode = node.isDeclaration() ? new FunctionDeclaration(this.peek(), node, method) : new FunctionExpression(this.peek(), node, method);
        method.setLocation(ReferenceLocation.create(this.referenceSource, node.start(), node.end(), functionNode.getNameNode()));
        functionNode.buildArgumentNodes();
        this.push(functionNode);
        this.declarations.push(node.getDeclarations());
        super.visitFunctionStatement(node);
        this.declarations.pop();
        return this.pop();
    }

    public IStructureNode visitReturnStatement(ReturnStatement node) {
        IParentNode peek;
        if (node.getValue() != null && (peek = this.peek()) instanceof FunctionNode) {
            if (node.getValue() instanceof StringLiteral) {
                ((FunctionNode)peek).setReturnType("String");
            } else if (node.getValue() instanceof DecimalLiteral) {
                ((FunctionNode)peek).setReturnType("Number");
            } else if (node.getValue() instanceof BooleanLiteral) {
                ((FunctionNode)peek).setReturnType("Boolean");
            } else {
                ((FunctionNode)peek).setReturnType("Object");
            }
        }
        return (IStructureNode)super.visitReturnStatement(node);
    }

    protected void processVariable(VariableDeclaration declaration) {
        IStructureHandler[] iStructureHandlerArray = this.handlers;
        int n = this.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IStructureHandler handler = iStructureHandlerArray[n2];
            IStructureNode value = handler.handle((ASTNode)declaration);
            if (value != IStructureHandler.CONTINUE) {
                if (value != null) {
                    this.peek().getScope().addChild(value);
                }
                return;
            }
            ++n2;
        }
        if (declaration.getInitializer() instanceof FunctionStatement) {
            this.peek().getScope().addChild(this.buildFunctionDeclarationFromAssignment((JSNode)declaration, (FunctionStatement)declaration.getInitializer(), Collections.singletonList(declaration.getIdentifier())));
            return;
        }
        JSVariable variable = new JSVariable(declaration.getVariableName());
        variable.setLocation(declaration.getInitializer() != null ? ReferenceLocation.create(this.referenceSource, declaration.start(), declaration.end(), (ISourceNode)declaration.getIdentifier()) : ReferenceLocation.create(this.referenceSource, declaration.start(), declaration.end()));
        this.jsdocSupport.processVariable(declaration, variable, this.fReporter, this.fTypeChecker);
        VariableNode variableNode = new VariableNode(this.peek(), declaration, variable);
        this.peek().getScope().addChild(variableNode);
        Expression initializer = declaration.getInitializer();
        if (initializer != null) {
            this.push(variableNode);
            variableNode.setValue(this.visit((ASTNode)initializer));
            this.pop();
        }
    }

    public IStructureNode visitObjectInitializer(ObjectInitializer node) {
        ObjectDeclaration object = new ObjectDeclaration(this.peek());
        for (ObjectInitializerPart part : node.getInitializers()) {
            String name;
            if (part instanceof GetMethod) {
                this.visitMethod((Method)((GetMethod)part));
                continue;
            }
            if (part instanceof SetMethod) {
                this.visitMethod((Method)((SetMethod)part));
                continue;
            }
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            if (pi.getName() instanceof Identifier) {
                name = ((Identifier)pi.getName()).getName();
            } else if (pi.getName() instanceof StringLiteral) {
                name = ((StringLiteral)pi.getName()).getValue();
            } else if (pi.getName() instanceof DecimalLiteral) {
                name = ((DecimalLiteral)pi.getName()).getText();
            } else {
                name = "";
                this.visit((ASTNode)pi.getName());
            }
            PropertyDeclaration propertyDeclaration = new PropertyDeclaration(this.peek(), name, pi, ReferenceLocation.create(this.referenceSource, pi.start(), pi.end(), (ISourceNode)pi.getName()));
            object.addChild(propertyDeclaration);
            this.push(propertyDeclaration);
            propertyDeclaration.setValue(this.visit((ASTNode)pi.getValue()));
            this.pop();
        }
        return !object.getChildren().isEmpty() ? object : null;
    }

    public IStructureNode visitPropertyExpression(PropertyExpression node) {
        this.visit((ASTNode)node.getObject());
        Expression property = node.getProperty();
        if (property instanceof Identifier) {
            Identifier identifier = (Identifier)property;
            if (this.isFunctionCall((Expression)node)) {
                this.peek().addMethodReference(identifier, StructureReporter3.getCallArgumentCount((Expression)node));
            } else {
                this.peek().addFieldReference(identifier);
            }
        } else {
            this.visit((ASTNode)property);
        }
        return null;
    }

    public IStructureNode visitIdentifier(Identifier node) {
        String name = node.getName();
        IDeclaration resolved = this.peek().getScope().resolve(name);
        if (resolved != null) {
            if (resolved.getParent() instanceof ScriptScope) {
                if (resolved instanceof FunctionNode) {
                    this.peek().addMethodReference(node, this.isFunctionCall((Expression)node) ? StructureReporter3.getCallArgumentCount((Expression)node) : 0);
                } else {
                    this.peek().addFieldReference(node);
                }
            } else {
                this.peek().addLocalReference(node, resolved);
            }
        } else if (this.isFunctionCall((Expression)node)) {
            this.peek().addMethodReference(node, StructureReporter3.getCallArgumentCount((Expression)node));
        } else {
            this.peek().addFieldReference(node);
        }
        return null;
    }

    public IStructureNode visitCallExpression(CallExpression node) {
        IStructureNode retValue = this.visit((ASTNode)node.getExpression());
        for (ASTNode argument : node.getArguments()) {
            IStructureNode visit = this.visit(argument);
            if (visit == null) continue;
            this.peek().getScope().addToScope(new ArgumentsStructureNode(visit));
        }
        return retValue;
    }

    public IStructureNode visitVoidExpression(VoidExpression node) {
        Expression expression = node.getExpression();
        if (expression instanceof FunctionStatement || expression instanceof VariableStatement || expression instanceof BinaryOperation && this.isAssignment((BinaryOperation)expression)) {
            this.visit((ASTNode)expression);
        } else {
            ExpressionNode expressionNode = new ExpressionNode(this.peek());
            this.push(expressionNode);
            this.visit((ASTNode)expression);
            this.pop();
        }
        return null;
    }

    private boolean isAssignment(BinaryOperation operation) {
        return operation.getOperation() == 104;
    }

    public IStructureNode visitBinaryOperation(BinaryOperation node) {
        if (node.getOperation() == 104) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            if (left instanceof PropertyExpression) {
                List path = ((PropertyExpression)left).getPath();
                boolean thisReference = false;
                if (path.get(0) instanceof ThisExpression) {
                    path.remove(0);
                    thisReference = true;
                }
                if (this.isValidPath(path)) {
                    if (right instanceof FunctionStatement) {
                        return this.buildFunctionDeclarationFromAssignment((JSNode)node, (FunctionStatement)right, path);
                    }
                    if (thisReference) {
                        FieldNode fieldNode = new FieldNode(this.peek(), (Expression)node, StructureReporter3.joinPath(path), ReferenceLocation.create(this.referenceSource, node.start(), node.end(), StructureReporter3.getNameNode(path)));
                        this.push(fieldNode);
                        this.visit((ASTNode)right);
                        return this.pop();
                    }
                }
            } else if (left instanceof Identifier && right instanceof FunctionStatement) {
                return this.buildFunctionDeclarationFromAssignment((JSNode)node, (FunctionStatement)right, Collections.singletonList(left));
            }
        }
        return (IStructureNode)super.visitBinaryOperation(node);
    }

    private IStructureNode buildFunctionDeclarationFromAssignment(JSNode node, FunctionStatement function, List<Expression> path) {
        JSMethod method = new JSMethod(function, ReferenceSource.UNKNOWN);
        this.jsdocSupport.processMethod(function, method, this.fReporter, this.fTypeChecker);
        FunctionDeclarationExpressionLike functionNode = new FunctionDeclarationExpressionLike(this.peek(), function, method, StructureReporter3.joinPath(path), StructureReporter3.getNameNode(path));
        method.setLocation(ReferenceLocation.create(this.referenceSource, node.start(), node.end(), ((FunctionNode)functionNode).getNameNode()));
        functionNode.buildArgumentNodes();
        this.push(functionNode);
        this.declarations.add(function.getDeclarations());
        super.visitFunctionStatement(function);
        this.declarations.pop();
        return this.pop();
    }

    private static ISourceNode getNameNode(List<Expression> path) {
        if (path.size() == 1) {
            return (ISourceNode)path.get(0);
        }
        return new NameNode(path.get(0).start(), path.get(path.size() - 1).end());
    }

    private static String joinPath(List<Expression> path) {
        if (path.size() == 1) {
            return ((Identifier)path.get(0)).getName();
        }
        StringBuilder sb = new StringBuilder();
        for (Expression expression : path) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(((Identifier)expression).getName());
        }
        return sb.toString();
    }

    private boolean isValidPath(List<Expression> path) {
        for (Expression expression : path) {
            if (expression instanceof Identifier) continue;
            return false;
        }
        return true;
    }

    private boolean isFunctionCall(Expression node) {
        if (StructureReporter3.isCallExpression(node)) {
            return true;
        }
        if (node instanceof Identifier) {
            String name = ((Identifier)node).getName();
            int i = this.declarations.size();
            while (--i >= 0) {
                List list = (List)this.declarations.get(i);
                for (JSDeclaration declaration : list) {
                    if (!(declaration instanceof FunctionStatement) || !name.equals(((FunctionStatement)declaration).getFunctionName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCallExpression(Expression node) {
        JSNode parent = node.getParent();
        return parent instanceof CallExpression && ((CallExpression)parent).getExpression() == node;
    }

    public static int getCallArgumentCount(Expression node) {
        if (StructureReporter3.isCallExpression(node)) {
            return ((CallExpression)node.getParent()).getArguments().size();
        }
        return 0;
    }

    private static class ArgumentsStructureNode
    implements IStructureNode {
        private IStructureNode wrapper;

        public ArgumentsStructureNode(IStructureNode wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public List<? extends IStructureNode> getChildren() {
            return this.wrapper.getChildren();
        }

        @Override
        public IParentNode getParent() {
            return this.wrapper.getParent();
        }

        @Override
        public IScope getScope() {
            return this.wrapper.getScope();
        }

        @Override
        public int start() {
            return this.wrapper.start();
        }

        @Override
        public boolean isManyChildren() {
            return this.wrapper.isManyChildren();
        }

        @Override
        public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
            context.pushMask(1);
            this.wrapper.reportStructure(requestor, context);
            context.popMask();
        }
    }
}

