/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinference;

import java.text.MessageFormat;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;

public abstract class ReferenceLocation {
    public static final ReferenceLocation UNKNOWN = new Unknown();

    public abstract ReferenceSource getSource();

    public ISourceModule getSourceModule() {
        return this.getSource().getSourceModule();
    }

    public abstract int getDeclarationStart();

    public abstract int getDeclarationEnd();

    public abstract int getNameStart();

    public abstract int getNameEnd();

    public boolean equals(Object obj) {
        ReferenceLocation loc;
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceLocation && (loc = (ReferenceLocation)obj).getDeclarationStart() == this.getDeclarationStart() && loc.getDeclarationEnd() == this.getDeclarationEnd() && loc.getNameStart() == this.getNameStart() && loc.getNameEnd() == this.getNameEnd()) {
            if (this.getSource() != null && this.getSource().equals(loc.getSource())) {
                return true;
            }
            return this.getSource() == loc.getSource();
        }
        return false;
    }

    public static ReferenceLocation create(ReferenceSource source, int declarationStart, int declarationEnd, int nameStart, int nameEnd) {
        return new SimpleLocation(source, declarationStart, declarationEnd, nameStart, nameEnd);
    }

    public static ReferenceLocation create(ReferenceSource source, int declarationStart, int declarationEnd, ISourceNode nameNode) {
        return ReferenceLocation.create(source, declarationStart, declarationEnd, nameNode.start(), nameNode.end());
    }

    public static ReferenceLocation create(ReferenceSource source, int start, int end) {
        return new RangeLocation(source, start, end);
    }

    private static class RangeLocation
    extends ReferenceLocation {
        private final ReferenceSource source;
        private final int start;
        private final int end;

        public RangeLocation(ReferenceSource source, int start, int end) {
            this.source = source;
            this.start = start;
            this.end = end;
        }

        @Override
        public ReferenceSource getSource() {
            return this.source;
        }

        @Override
        public int getDeclarationEnd() {
            return this.end;
        }

        @Override
        public int getDeclarationStart() {
            return this.start;
        }

        @Override
        public int getNameEnd() {
            return this.end;
        }

        @Override
        public int getNameStart() {
            return this.start;
        }

        public String toString() {
            return this.source + "[" + this.start + ".." + this.end + "]";
        }
    }

    private static class SimpleLocation
    extends ReferenceLocation {
        private final ReferenceSource source;
        private final int declarationStart;
        private final int declarationEnd;
        private final int nameStart;
        private final int nameEnd;

        public SimpleLocation(ReferenceSource source, int declarationStart, int declarationEnd, int nameStart, int nameEnd) {
            this.source = source;
            this.declarationStart = declarationStart;
            this.declarationEnd = declarationEnd;
            this.nameStart = nameStart;
            this.nameEnd = nameEnd;
        }

        @Override
        public ReferenceSource getSource() {
            return this.source;
        }

        @Override
        public int getDeclarationEnd() {
            return this.declarationEnd;
        }

        @Override
        public int getDeclarationStart() {
            return this.declarationStart;
        }

        @Override
        public int getNameEnd() {
            return this.nameEnd;
        }

        @Override
        public int getNameStart() {
            return this.nameStart;
        }

        public String toString() {
            return this.source + MessageFormat.format("[{0}..{1},{2}..{3}]", this.declarationStart, this.declarationEnd, this.nameStart, this.nameEnd);
        }
    }

    static class Unknown
    extends ReferenceLocation {
        Unknown() {
        }

        @Override
        public ReferenceSource getSource() {
            return ReferenceSource.UNKNOWN;
        }

        @Override
        public int getNameStart() {
            return 0;
        }

        @Override
        public int getNameEnd() {
            return 0;
        }

        @Override
        public int getDeclarationStart() {
            return 0;
        }

        @Override
        public int getDeclarationEnd() {
            return 0;
        }

        public String toString() {
            return "UNKNOWN";
        }
    }
}

