/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.parser.SourceParserManager;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierExtension2;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.IDLTKContributedExtension;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.preferences.JavaScriptPreferenceMessages;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.IPreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.PreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class JavaScriptErrorWarningConfigurationBlock
extends AbstractOptionsBlock {
    private static final String EXT_POINT_PROBLEM_SECTIONS = "org.eclipse.dltk.javascript.ui.problemSections";
    private static final String SETTINGS_SECTION_NAME = "ProblemSeveritiesConfigurationBlock";

    public JavaScriptErrorWarningConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, new PreferenceKey[0], container);
    }

    protected List<ProblemSection> loadProblemSections() {
        ArrayList<ProblemSection> sections = new ArrayList<ProblemSection>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_POINT_PROBLEM_SECTIONS);
        HashSet<IProblemIdentifier> identifiers = new HashSet<IProblemIdentifier>();
        HashMap<String, ProblemSection> defaultEntries = new HashMap<String, ProblemSection>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String sectionId = element.getAttribute("id");
            String sectionName = element.getAttribute("name");
            ProblemSection problemSection = null;
            if (sectionId != null) {
                for (ProblemSection section : sections) {
                    if (!sectionId.equals(section.id)) continue;
                    problemSection = section;
                    break;
                }
            }
            if (problemSection == null) {
                problemSection = new ProblemSection(sectionId, sectionName);
                try {
                    problemSection.priority = Integer.parseInt(element.getAttribute("priority"));
                }
                catch (NumberFormatException numberFormatException) {}
                sections.add(problemSection);
            }
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("problem");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement problemElement = iConfigurationElementArray2[n4];
                String problemId = problemElement.getAttribute("id");
                IProblemIdentifier identifier = DefaultProblemIdentifier.decode((String)problemId);
                if (identifier != null && identifiers.add(identifier)) {
                    if (identifier instanceof IProblemIdentifierExtension2 && ((IProblemIdentifierExtension2)identifier).getPrimeIdentifier() != null) {
                        JavaScriptPlugin.error((String)("Skip dependent " + problemId));
                    } else {
                        String problemLabel = problemElement.getAttribute("label");
                        if (problemLabel == null || problemLabel.length() == 0) {
                            problemLabel = identifier.name();
                        }
                        if (!problemSection.items.containsKey(identifier)) {
                            problemSection.items.put(identifier, problemLabel);
                        }
                    }
                }
                ++n4;
            }
            iConfigurationElementArray2 = element.getChildren("defaultEntry");
            n3 = iConfigurationElementArray2.length;
            n4 = 0;
            while (n4 < n3) {
                IConfigurationElement defaultEntry = iConfigurationElementArray2[n4];
                String namespace = defaultEntry.getAttribute("namespace");
                if (namespace != null) {
                    defaultEntries.put(namespace, problemSection);
                }
                ++n4;
            }
            ++n2;
        }
        for (Map.Entry entry : defaultEntries.entrySet()) {
            IProblemIdentifier[] namespaceItems = DefaultProblemIdentifier.values((String)((String)entry.getKey()));
            if (namespaceItems == null) continue;
            IProblemIdentifier[] iProblemIdentifierArray = namespaceItems;
            int n5 = namespaceItems.length;
            int n6 = 0;
            while (n6 < n5) {
                IProblemIdentifier item = iProblemIdentifierArray[n6];
                if (!(item instanceof IProblemIdentifierExtension2 && ((IProblemIdentifierExtension2)item).getPrimeIdentifier() != null || identifiers.contains(item))) {
                    ((ProblemSection)entry.getValue()).items.put(item, item.name());
                }
                ++n6;
            }
        }
        Collections.sort(sections, new Comparator<ProblemSection>(){

            @Override
            public int compare(ProblemSection s1, ProblemSection s2) {
                return s1.priority - s2.priority;
            }
        });
        return sections;
    }

    public Control createOptionsBlock(Composite parent) {
        String[] ids;
        IDLTKContributedExtension[] extensions;
        ScrolledPageContent sc1 = new ScrolledPageContent(parent);
        GridData gridData = new GridData(1808);
        gridData.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(20);
        sc1.setLayoutData((Object)gridData);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        if (this.isProjectPreferencePage() && (extensions = SourceParserManager.getInstance().getContributions("org.eclipse.dltk.javascript.core.nature")).length > 1) {
            SWTFactory.createLabel((Composite)composite, (String)"Parser", (int)1);
            ids = new String[extensions.length];
            String[] names = new String[extensions.length];
            int i = 0;
            while (i < extensions.length) {
                ids[i] = extensions[i].getId();
                names[i] = extensions[i].getName();
                ++i;
            }
            this.bindControl(SWTFactory.createCombo((Composite)composite, (int)8, (int)1, (int)0, (String[])names), new PreferenceKey("org.eclipse.dltk.core", "org.eclipse.dltk.core.sourceParserId"), ids);
        }
        SWTFactory.createLabel((Composite)composite, (String)JavaScriptPreferenceMessages.ErrorWarningDescription, (int)2);
        String[] names = new String[]{"Warning", "Error", "Info", "Ignore"};
        ids = new String[]{ProblemSeverity.WARNING.name(), ProblemSeverity.ERROR.name(), ProblemSeverity.INFO.name(), ProblemSeverity.IGNORE.name()};
        for (ProblemSection problemSection : this.loadProblemSections()) {
            if (problemSection.items.isEmpty()) continue;
            ExpandableComposite excomposite = this.createStyleSection(composite, problemSection.name, 2);
            Composite inner = new Composite((Composite)excomposite, 0);
            inner.setFont(composite.getFont());
            inner.setLayout((Layout)new GridLayout(2, false));
            excomposite.setClient((Control)inner);
            for (Map.Entry<IProblemIdentifier, String> entry : problemSection.items.entrySet()) {
                SWTFactory.createLabel((Composite)inner, (String)entry.getValue(), (int)1).setLayoutData((Object)new GridData(4, 2, true, false));
                this.bindControl(SWTFactory.createCombo((Composite)inner, (int)8, (int)1, (int)0, (String[])names), JavaScriptErrorWarningConfigurationBlock.key(entry.getKey()), ids);
            }
        }
        this.restoreSectionExpansionStates(this.getSettings(false));
        return composite;
    }

    protected IDialogSettings getSettings(boolean create) {
        IDialogSettings dialogSettings = JavaScriptUI.getDefault().getDialogSettings();
        return create ? dialogSettings.addNewSection(SETTINGS_SECTION_NAME) : dialogSettings.getSection(SETTINGS_SECTION_NAME);
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getSettings(true));
        super.dispose();
    }

    private static PreferenceKey key(IProblemIdentifier identifier) {
        return new PreferenceKey(identifier.contributor(), DefaultProblemIdentifier.encode((IProblemIdentifier)identifier));
    }

    protected IPreferenceChangeRebuildPrompt getPreferenceChangeRebuildPrompt(boolean workspaceSettings, Collection<PreferenceKey> changedOptions) {
        return PreferenceChangeRebuildPrompt.create((boolean)workspaceSettings, (String)"Error/Warning Settings Changed", (String)"The error/warning settings have changed.");
    }

    protected Job[] createBuildJobs(IProject project) {
        Job[] jobs = super.createBuildJobs(project);
        Job[] result = new Job[jobs.length + 1];
        System.arraycopy(jobs, 0, result, 1, jobs.length);
        Job job0 = jobs[0];
        result[0] = new Job(job0.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                SourceParserUtil.clearCache();
                return Status.OK_STATUS;
            }
        };
        result[0].setRule(job0.getRule());
        result[0].setUser(job0.isUser());
        result[0].setSystem(job0.isSystem());
        return result;
    }

    protected static class ProblemSection {
        final String id;
        final String name;
        int priority = 1000;
        final Map<IProblemIdentifier, String> items = new LinkedHashMap<IProblemIdentifier, String>();

        public ProblemSection(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

