/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.parser;

import java.io.IOException;
import java.io.Reader;

public final class PythonScriptFilteringReader
extends Reader {
    private boolean ls;
    private boolean mn;
    private boolean ma;
    private boolean inString;
    private int sttype;
    private boolean last;
    private char[] content;
    private int position;
    public static final int NONE = 0;
    public static final int SINGLE_QUATA = 1;
    public static final int DOUBLE_QUATA = 2;
    public static final int TRIPLE_QUATA = 3;
    public static final int TRIPLE_Q = 4;
    private char c;

    public PythonScriptFilteringReader(char[] content) {
        this.content = content;
        this.position = 0;
    }

    public void reset() throws IOException {
        this.position = 0;
    }

    public void appendNewLine() {
    }

    private boolean isEscape() {
        int ma = this.position - 2;
        boolean esc = false;
        while (ma > 0 && this.content[ma] == '\\') {
            --ma;
            boolean bl = esc = !esc;
        }
        return esc;
    }

    private int get(int p) {
        if (p < this.content.length) {
            return this.content[p];
        }
        return -1;
    }

    private void checkInString() {
        if (!this.ma) {
            switch (this.sttype) {
                case 0: {
                    if (this.c == '\"') {
                        if (this.get(this.position) == 34 && this.get(this.position + 1) == 34) {
                            this.sttype = 3;
                            break;
                        }
                        this.sttype = 2;
                    }
                    if (this.c != '\'') break;
                    if (this.get(this.position) == 39 && this.get(this.position + 1) == 39) {
                        this.sttype = 4;
                        break;
                    }
                    this.sttype = 1;
                    break;
                }
                case 1: {
                    if (this.c != '\'' || this.isEscape()) break;
                    this.sttype = 0;
                    break;
                }
                case 2: {
                    if (this.c != '\"' || this.isEscape()) break;
                    this.sttype = 0;
                    break;
                }
                case 3: {
                    if (this.c != '\"' || this.get(this.position) != 34 || this.get(this.position + 1) != 34) break;
                    this.sttype = 0;
                    break;
                }
                case 4: {
                    if (this.c != '\'' || this.get(this.position) != 39 || this.get(this.position + 1) != 39) break;
                    this.sttype = 0;
                }
            }
            this.inString = this.sttype != 0;
        }
    }

    public int read() throws IOException {
        if (this.ready()) {
            this.c = this.content[this.position];
            if (this.c == '\n') {
                this.appendNewLine();
            }
            ++this.position;
            this.checkInString();
            if (!this.inString && this.c == '#') {
                this.ma = true;
                return 32;
            }
            if (this.c == '\n') {
                this.ma = false;
            }
            if (this.c == '\r') {
                this.ma = false;
            }
            if (this.ma) {
                return 32;
            }
            if (this.c == '\n' && this.mn) {
                this.mn = false;
                return 32;
            }
            if (this.c == '\\') {
                if (this.position == this.content.length) {
                    return this.c;
                }
                char la = this.content[this.position];
                if (la != ' ' && la != '\n' && la != '\r' && la != '\r') {
                    return this.c;
                }
                this.ls = true;
                return 32;
            }
            if (this.ls) {
                if (this.c == '\t') {
                    return this.c;
                }
                if (this.c == '\n') {
                    this.ls = false;
                    return 32;
                }
                if (this.c == '\r') {
                    this.ls = false;
                    this.mn = true;
                    return 32;
                }
                if (this.c == '\t' && this.inString) {
                    return 32;
                }
                return this.c;
            }
            if (this.inString && this.c == '\t') {
                return 32;
            }
            return this.c;
        }
        if (!this.last) {
            this.last = true;
            return 10;
        }
        return -1;
    }

    public boolean ready() throws IOException {
        return this.position < this.content.length;
    }

    public void close() throws IOException {
    }

    public int read(char[] pArg0, int off, int length) throws IOException {
        int code = 0;
        int e = off + length;
        int a = off;
        while (a < e) {
            code = this.read();
            pArg0[a] = (char)code;
            ++a;
        }
        return code;
    }
}

