/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.utils.CorePrinter;

public class RubyWhileStatement
extends ASTNode {
    private ASTNode fCondition;
    private ASTNode fAction;

    public RubyWhileStatement(ASTNode condition, ASTNode action) {
        this.fCondition = condition;
        this.fAction = action;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((ASTNode)this)) {
            if (this.fCondition != null) {
                this.fCondition.traverse(pVisitor);
            }
            if (this.fAction != null) {
                this.fAction.traverse(pVisitor);
            }
            pVisitor.endvisit((ASTNode)this);
        }
    }

    public ASTNode getCondition() {
        return this.fCondition;
    }

    public ASTNode getAction() {
        return this.fAction;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("while");
        if (this.fCondition != null) {
            this.fCondition.printNode(output);
        }
        if (this.fAction != null) {
            output.indent();
            this.fAction.printNode(output);
            output.dedent();
        }
        output.formatPrint("");
    }
}

