/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.MethodIndex;

public final class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    static final long serialVersionUID = -1993752395320088525L;
    private final Node receiverNode;
    private String name;
    private Node argsNode;
    private Node iterNode;
    public final int index;

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        this(position, receiverNode, name, argsNode, null);
    }

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode) {
        super(position, 15);
        this.receiverNode = receiverNode;
        this.name = name.intern();
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.index = MethodIndex.getIndex(this.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = this.name.intern();
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    public void setIterNode(Node iterNode) {
        this.iterNode = iterNode;
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
    }

    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public List childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    public String toString() {
        return "CallNode: " + this.getName();
    }
}

