/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.search.MethodNameMatch;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.corext.util.CorextMessages;
import org.eclipse.dltk.internal.corext.util.History;
import org.eclipse.dltk.internal.corext.util.MethodFilter;
import org.eclipse.dltk.internal.corext.util.MethodInfoFilter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.w3c.dom.Element;

public class OpenMethodHistory
extends History {
    MethodFilter fMethodFilter = null;
    private static Map sToolkitHistory = new HashMap();
    private static final String FAMILY = UpdateJob.class.getName();
    private volatile boolean fNeedsConsistencyCheck = true;
    private Map fTimestampMapping = new HashMap();
    private final IElementChangedListener fDeltaListener;
    private final UpdateJob fUpdateJob;
    private static final String FILENAME = "OpenMethodHistory";
    private static final String NODE_ROOT = "methodInfoHistroy";
    private static final String NODE_TYPE_INFO = "methodInfo";
    private static final String NODE_HANDLE = "handle";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final String NODE_TIMESTAMP = "timestamp";

    public static synchronized OpenMethodHistory getInstance(IDLTKUILanguageToolkit toolkit) {
        if (sToolkitHistory.containsKey(toolkit)) {
            return (OpenMethodHistory)sToolkitHistory.get(toolkit);
        }
        OpenMethodHistory his = new OpenMethodHistory(toolkit);
        sToolkitHistory.put(toolkit, his);
        return his;
    }

    private OpenMethodHistory(IDLTKUILanguageToolkit toolkit) {
        super(FILENAME + toolkit.getCoreToolkit().getNatureId().replace('.', '_') + ".xml", NODE_ROOT, NODE_TYPE_INFO);
        this.load();
        this.fDeltaListener = new MethodHistoryDeltaListener();
        DLTKCore.addElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.fUpdateJob = new UpdateJob();
        this.fUpdateJob.setPriority(20);
        this.fMethodFilter = new MethodFilter(toolkit);
    }

    public void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    public boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    public void checkConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        if (this.fUpdateJob.getState() == 4) {
            try {
                Job.getJobManager().join((Object)FAMILY, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        this.internalCheckConsistency(monitor);
    }

    public synchronized boolean contains(MethodNameMatch type) {
        return super.contains(type);
    }

    public synchronized void accessed(MethodNameMatch info) {
        if (!this.fTimestampMapping.containsKey(info)) {
            this.fTimestampMapping.put(info, new Long(this.getContainerTimestamp(info)));
        }
        super.accessed(info);
    }

    public synchronized MethodNameMatch remove(MethodNameMatch info) {
        this.fTimestampMapping.remove(info);
        return (MethodNameMatch)super.remove(info);
    }

    public synchronized void replace(MethodNameMatch old, MethodNameMatch newMatch) {
        this.fTimestampMapping.remove(old);
        this.fTimestampMapping.put(newMatch, new Long(this.getContainerTimestamp(newMatch)));
        super.remove(old);
        super.accessed(newMatch);
    }

    public synchronized MethodNameMatch[] getTypeInfos() {
        Collection values = this.getValues();
        int size = values.size();
        MethodNameMatch[] result = new MethodNameMatch[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (MethodNameMatch)iter.next();
            --i;
        }
        return result;
    }

    public synchronized MethodNameMatch[] getFilteredTypeInfos(MethodInfoFilter filter) {
        Collection values = this.getValues();
        ArrayList<MethodNameMatch> result = new ArrayList<MethodNameMatch>();
        for (MethodNameMatch method : values) {
            if (filter != null && !filter.matchesHistoryElement(method) || this.fMethodFilter.isFiltered(method.getFullyQualifiedName())) continue;
            result.add(method);
        }
        Collections.reverse(result);
        return result.toArray(new MethodNameMatch[result.size()]);
    }

    @Override
    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        this.fNeedsConsistencyCheck = true;
        ArrayList typesToCheck = new ArrayList(this.getKeys());
        monitor.beginTask(CorextMessages.MethodInfoHistory_consistency_check, typesToCheck.size());
        monitor.setTaskName(CorextMessages.MethodInfoHistory_consistency_check);
        for (MethodNameMatch type : typesToCheck) {
            long currentTimestamp = this.getContainerTimestamp(type);
            Long lastTested = (Long)this.fTimestampMapping.get(type);
            if (lastTested != null && currentTimestamp != -1L && currentTimestamp == lastTested && !this.isContainerDirty(type)) continue;
            try {
                IMethod sMethod = type.getMethod();
                if (sMethod == null || !sMethod.exists()) {
                    this.remove(type);
                } else {
                    int modifiers = sMethod.getFlags();
                    if (modifiers != type.getModifiers()) {
                        this.replace(type, SearchEngine.createMethodNameMatch((IMethod)sMethod, (int)modifiers));
                    } else {
                        this.fTimestampMapping.put(type, new Long(currentTimestamp));
                    }
                }
            }
            catch (ModelException modelException) {
                this.remove(type);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        monitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    private long getContainerTimestamp(MethodNameMatch match) {
        try {
            IMethod method = match.getMethod();
            IResource resource = method.getResource();
            if (resource != null) {
                IModelElement element;
                IFileInfo info;
                URI location = resource.getLocationURI();
                if (location != null && (info = EFS.getStore((URI)location).fetchInfo()).exists() && (element = DLTKCore.create((IResource)resource)) != null && element.exists()) {
                    return info.getLastModified();
                }
            } else {
                IFileInfo info;
                IProjectFragment root = match.getProjectFragment();
                if (root.exists() && (info = EFS.getLocalFileSystem().getStore(root.getPath()).fetchInfo()).exists()) {
                    return info.getLastModified();
                }
            }
        }
        catch (CoreException coreException) {}
        return -1L;
    }

    public boolean isContainerDirty(MethodNameMatch match) {
        ITextFileBufferManager manager;
        ITextFileBuffer textFileBuffer;
        ISourceModule cu = match.getMethod().getSourceModule();
        if (cu == null) {
            return false;
        }
        IResource resource = cu.getResource();
        if (resource != null && (textFileBuffer = (manager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(resource.getFullPath(), LocationKind.NORMALIZE)) != null) {
            return textFileBuffer.isDirty();
        }
        return false;
    }

    public void shutdown() {
        DLTKCore.removeElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.save();
    }

    @Override
    protected Object createFromElement(Element type) {
        String handle = type.getAttribute(NODE_HANDLE);
        if (handle == null) {
            return null;
        }
        IModelElement element = DLTKCore.create((String)handle);
        if (!(element instanceof IMethod)) {
            return null;
        }
        int modifiers = 0;
        try {
            modifiers = Integer.parseInt(type.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {}
        MethodNameMatch info = SearchEngine.createMethodNameMatch((IMethod)((IMethod)element), (int)modifiers);
        long timestamp = -1L;
        String timestampValue = type.getAttribute(NODE_TIMESTAMP);
        if (timestampValue != null && timestampValue.length() > 0) {
            try {
                timestamp = Long.parseLong(timestampValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (timestamp != -1L) {
            this.fTimestampMapping.put(info, new Long(timestamp));
        }
        return info;
    }

    @Override
    protected void setAttributes(Object object, Element typeElement) {
        MethodNameMatch method = (MethodNameMatch)object;
        String handleId = method.getMethod().getHandleIdentifier();
        typeElement.setAttribute(NODE_HANDLE, handleId);
        typeElement.setAttribute(NODE_MODIFIERS, Integer.toString(method.getModifiers()));
        Long timestamp = (Long)this.fTimestampMapping.get(method);
        if (timestamp == null) {
            typeElement.setAttribute(NODE_TIMESTAMP, Long.toString(-1L));
        } else {
            typeElement.setAttribute(NODE_TIMESTAMP, timestamp.toString());
        }
    }

    private class MethodHistoryDeltaListener
    implements IElementChangedListener {
        private MethodHistoryDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.processDelta(event.getDelta())) {
                OpenMethodHistory.this.markAsInconsistent();
            }
        }

        private boolean processDelta(IModelElementDelta delta) {
            IModelElement elem = delta.getElement();
            boolean isChanged = delta.getKind() == 4;
            boolean isRemoved = delta.getKind() == 2;
            switch (elem.getElementType()) {
                case 2: {
                    if (isRemoved || isChanged && (delta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 3: {
                    if (isRemoved || isChanged && ((delta.getFlags() & 0x8000) != 0 || (delta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 9: {
                    return isRemoved || isChanged && (delta.getFlags() & 2) != 0;
                }
                case 1: 
                case 4: {
                    if (isRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!ScriptModelUtil.isPrimary((ISourceModule)((ISourceModule)elem))) {
                        return false;
                    }
                    if (isRemoved || isChanged && this.isUnknownStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int flags) {
            if ((flags & 1) == 0) {
                return false;
            }
            return (flags & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IModelElementDelta delta) {
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private class UpdateJob
    extends Job {
        public UpdateJob() {
            super(CorextMessages.MethodInfoHistory_consistency_check);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OpenMethodHistory.this.internalCheckConsistency(monitor);
            return new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return FAMILY.equals(family);
        }
    }
}

