/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.declarations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.utils.ASTUtil;
import org.eclipse.dltk.utils.CorePrinter;

public class TypeDeclaration
extends Declaration {
    protected int bodyEnd;
    protected int bodyStart;
    protected int parentEnd;
    protected int parentStart;
    protected ASTListNode fSuperClasses;
    protected Block fBody;
    protected List fMethods;
    protected List fTypes;
    protected List fVariables;
    protected String enclosingTypeName;

    public TypeDeclaration(DLTKToken name, int start, int end) {
        super(name, start, end);
    }

    public TypeDeclaration(String name, int nameStart, int nameEnd, int start, int end) {
        super(start, end);
        this.setName(name);
        this.setNameStart(nameStart);
        this.setNameEnd(nameEnd);
        this.enclosingTypeName = "";
    }

    public List getMethodList() {
        if (this.fMethods == null) {
            this.initInners();
        }
        return this.fMethods;
    }

    public List getFieldList() {
        if (this.fVariables == null) {
            this.initInners();
        }
        return this.fVariables;
    }

    public List getTypeList() {
        if (this.fTypes == null) {
            this.initInners();
        }
        return this.fTypes;
    }

    public void setEnclosingTypeName(String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        if (name != null && name.length() > 0) {
            this.enclosingTypeName = name;
        }
    }

    public String getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    public TypeDeclaration(DLTKToken name) {
        this.setName(name.getText());
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            if (this.getSuperClasses() != null) {
                this.getSuperClasses().traverse(visitor);
            }
            if (this.fBody != null) {
                this.fBody.traverse(visitor);
            }
            visitor.endvisit(this);
        }
    }

    public ASTListNode getSuperClasses() {
        return this.fSuperClasses;
    }

    public void setSuperClasses(ASTListNode exprList) {
        this.fSuperClasses = exprList;
    }

    public void addSuperClass(ASTNode expression) {
        if (this.fSuperClasses == null) {
            this.fSuperClasses = new ASTListNode();
        }
        this.fSuperClasses.addNode(expression);
    }

    @Override
    public int getKind() {
        return 3001;
    }

    public int getBodyEnd() {
        if (this.getBody() != null) {
            return this.getBody().sourceEnd();
        }
        return this.bodyEnd;
    }

    protected void setBodyEnd(int bodyEnd) {
        this.bodyEnd = bodyEnd;
    }

    public int getBodyStart() {
        if (this.getBody() != null) {
            return this.getBody().sourceStart();
        }
        return this.bodyStart;
    }

    protected void setBodyStart(int bodyStart) {
        this.bodyStart = bodyStart;
    }

    public int getDeclarationSourceEnd() {
        return this.sourceEnd();
    }

    protected void setDeclarationSourceEnd(int declarationSourceEnd) {
        this.setEnd(declarationSourceEnd);
    }

    public int getDeclarationSourceStart() {
        return this.sourceStart();
    }

    protected void setDeclarationSourceStart(int declarationSourceStart) {
        this.setStart(declarationSourceStart);
    }

    public int getParentEnd() {
        return this.parentEnd;
    }

    protected void setParentEnd(int parentEnd) {
        this.parentEnd = parentEnd;
    }

    public int getParentStart() {
        return this.parentStart;
    }

    protected void setParentStart(int parentStart) {
        this.parentStart = parentStart;
    }

    public void setBody(Block body) {
        this.fBody = body;
        if (body != null) {
            this.bodyStart = body.sourceStart();
            this.bodyEnd = body.sourceEnd();
        }
    }

    public Block getBody() {
        return this.fBody;
    }

    public void setBody(int startBody, Block body, int endBody) {
        this.setBody(body);
        this.setBodyStart(startBody);
        this.setBodyEnd(endBody);
    }

    public List getSuperClassNames() {
        if (this.fSuperClasses != null) {
            List<ASTNode> superClasses = this.fSuperClasses.getChilds();
            ArrayList<String> names = new ArrayList<String>(superClasses.size());
            for (ASTNode expr : superClasses) {
                String name = this.resolveSuperClassReference(expr);
                if (name == null) continue;
                names.add(name);
            }
            return names;
        }
        return Collections.EMPTY_LIST;
    }

    public String resolveSuperClassReference(ASTNode node) {
        if (node instanceof SimpleReference) {
            return ((SimpleReference)node).getName();
        }
        return null;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn("Type" + this.getSourceRange().toString() + this.getNameSourceRange().toString() + ":");
        String name = this.getName();
        if (name != null) {
            output.formatPrintLn(name);
        }
        if (this.fSuperClasses != null) {
            output.formatPrintLn("(");
            this.fSuperClasses.printNode(output);
            output.formatPrintLn(")");
        }
        if (this.fBody != null) {
            this.fBody.printNode(output);
        }
    }

    public MethodDeclaration[] getMethods() {
        if (this.fMethods == null) {
            this.initInners();
        }
        return ASTUtil.getMethods(this.getStatements(), this.fMethods);
    }

    public TypeDeclaration[] getTypes() {
        if (this.fTypes == null) {
            this.initInners();
        }
        return ASTUtil.getTypes(this.getStatements(), this.fTypes);
    }

    private void initInners() {
        this.fMethods = new ArrayList();
        this.fTypes = new ArrayList();
        this.fVariables = new ArrayList();
    }

    public List getStatements() {
        if (this.fBody == null) {
            this.fBody = new Block(this.sourceStart(), this.sourceEnd(), null);
        }
        return this.fBody.getStatements();
    }

    public ASTNode[] getNonTypeOrMethodNode() {
        List statements = this.getStatements();
        if (statements != null) {
            Iterator i = statements.iterator();
            ArrayList<ASTNode> results = new ArrayList<ASTNode>();
            while (i.hasNext()) {
                ASTNode node = (ASTNode)i.next();
                if (node instanceof TypeDeclaration || node instanceof MethodDeclaration) continue;
                results.add(node);
            }
            return results.toArray(new ASTNode[results.size()]);
        }
        return null;
    }

    public FieldDeclaration[] getVariables() {
        if (this.fVariables == null) {
            this.initInners();
        }
        return ASTUtil.getVariables(this.getStatements(), this.fVariables);
    }

    @Override
    public String debugString() {
        String prev = super.debugString();
        if ((this.getModifiers() & 0x400) != 0) {
            prev = String.valueOf(prev) + "(module)";
        }
        return prev;
    }

    @Override
    public int matchStart() {
        return this.getNameStart();
    }

    @Override
    public int matchLength() {
        return this.getNameEnd() - this.getNameStart();
    }
}

