/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationCommand;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.internal.debug.core.model.ScriptValueProxy;
import org.eclipse.dltk.internal.debug.core.model.ScriptWatchExpressionDelegate;

public class TclWatchExpressionDelegate
extends ScriptWatchExpressionDelegate {
    protected String prepareExpression(String expression) {
        if (expression.startsWith("$")) {
            return "expr { " + expression + " }";
        }
        return expression;
    }

    protected ScriptWatchExpressionDelegate.ListenerAdpater createListener(IWatchExpressionListener listener, String expression) {
        return new TclListenerAdapter(listener, expression);
    }

    private static class TclListenerAdapter
    extends ScriptWatchExpressionDelegate.ListenerAdpater {
        private final String expression;

        public TclListenerAdapter(IWatchExpressionListener listener, String expression) {
            super(listener);
            this.expression = expression;
        }

        public void evaluationComplete(IScriptEvaluationResult result) {
            if (result != null && result.getValue() != null) {
                this.listener.watchEvaluationFinished((IWatchExpressionResult)new TclWatchExpressionResult(result.getErrorMessages(), result.getException(), this.expression, (IValue)new TclWatchExpressionValueProxy(result.getValue(), this.expression), result.hasErrors()));
            } else {
                super.evaluationComplete(result);
            }
        }
    }

    private static class TclWatchExpressionResult
    implements IWatchExpressionResult {
        private final String[] errorMessages;
        private final DebugException exception;
        private final String expressionText;
        private final IValue value;
        private final boolean errors;

        public TclWatchExpressionResult(String[] errorMessages, DebugException exception, String expressionText, IValue value, boolean errors) {
            this.errorMessages = errorMessages;
            this.errors = errors;
            this.exception = exception;
            this.expressionText = expressionText;
            this.value = value;
        }

        public String[] getErrorMessages() {
            return this.errorMessages;
        }

        public DebugException getException() {
            return this.exception;
        }

        public String getExpressionText() {
            return this.expressionText;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return this.errors;
        }
    }

    private static final class TclWatchExpressionValueProxy
    extends ScriptValueProxy {
        private final String expression;

        private TclWatchExpressionValueProxy(IScriptValue origin, String expression) {
            super(origin);
            this.expression = expression;
        }

        public String getEvalName() {
            return this.expression;
        }

        public IScriptEvaluationCommand createEvaluationCommand(String messageTemplate, IScriptThread thread) {
            return null;
        }
    }
}

