/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.launching.AbstractInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.tcl.internal.launching.TclInterpreterRunner;
import org.eclipse.dltk.tcl.launching.TclLaunchingPlugin;
import org.osgi.framework.Bundle;

public class GenericTclInstall
extends AbstractInterpreterInstall {
    private static final Map<IInterpreterInstall, BuiltinsHelper> helpers = new HashMap<IInterpreterInstall, BuiltinsHelper>();

    public GenericTclInstall(IInterpreterInstallType type, String id) {
        super(type, id);
    }

    public IInterpreterRunner getInterpreterRunner(String mode) {
        IInterpreterRunner runner = super.getInterpreterRunner(mode);
        if (runner != null) {
            return runner;
        }
        if (mode.equals("run")) {
            return new TclInterpreterRunner((IInterpreterInstall)this);
        }
        return null;
    }

    public String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public String getBuiltinModuleContent(String name) {
        BuiltinsHelper helper = this.initialize();
        return helper.source.toString();
    }

    public long lastModified() {
        BuiltinsHelper helper = this.initialize();
        return helper.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuiltinsHelper initialize() {
        BuiltinsHelper helper;
        Object object = helpers;
        synchronized (object) {
            helper = helpers.get((Object)this);
            if (helper == null) {
                helper = new BuiltinsHelper(this);
                helpers.put((IInterpreterInstall)this, helper);
            }
        }
        object = helper;
        synchronized (object) {
            if (!helper.initialized) {
                helper.load();
            }
        }
        return helper;
    }

    public String[] getBuiltinModules() {
        return new String[]{"builtins.tcl"};
    }

    public static class BuiltinsHelper {
        private static final String BUILTINST_INFORMATION = "tcl_builtins_information";
        private final GenericTclInstall install;
        StringBuffer source = new StringBuffer();
        long lastModified;
        boolean initialized = false;

        public BuiltinsHelper(GenericTclInstall install) {
            this.install = install;
        }

        void load() {
            block3: {
                final IContentCache cache = ModelManager.getModelManager().getCoreCache();
                String builtins = cache.getCacheEntryAttributeString(this.install.getInstallLocation(), BUILTINST_INFORMATION, true);
                if (builtins != null) {
                    this.source.append(builtins);
                    this.lastModified = System.currentTimeMillis();
                    this.initialized = true;
                    return;
                }
                Job loadTclBuiltin = new Job("Generate Tcl builtin file..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Generate Tcl builtin file", -1);
                        IExecutionEnvironment exeEnv = install.getExecEnvironment();
                        if (exeEnv == null) {
                            return Status.CANCEL_STATUS;
                        }
                        String bundlePath = "scripts/builtins.tcl";
                        String content = ScriptLaunchUtil.runEmbeddedScriptReadContent((IExecutionEnvironment)exeEnv, (String)bundlePath, (Bundle)TclLaunchingPlugin.getDefault().getBundle(), (IFileHandle)install.getInstallLocation(), (IProgressMonitor)monitor);
                        if (content != null) {
                            cache.setCacheEntryAttribute(install.getInstallLocation(), BuiltinsHelper.BUILTINST_INFORMATION, content);
                        }
                        if (content != null) {
                            source.append(content);
                            lastModified = System.currentTimeMillis();
                            initialized = true;
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                loadTclBuiltin.schedule();
                try {
                    loadTclBuiltin.join();
                }
                catch (InterruptedException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }
}

