/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.internal.corext.util.CorextMessages;
import org.eclipse.dltk.internal.corext.util.History;
import org.eclipse.dltk.internal.corext.util.TypeFilter;
import org.eclipse.dltk.internal.corext.util.TypeInfoFilter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.w3c.dom.Element;

public class OpenTypeHistory
extends History
implements IShutdownListener {
    TypeFilter fTypeFilter = null;
    private static Map<IDLTKUILanguageToolkit, OpenTypeHistory> sToolkitHistory = new HashMap<IDLTKUILanguageToolkit, OpenTypeHistory>();
    private static final String FAMILY = UpdateJob.class.getName();
    private volatile boolean fNeedsConsistencyCheck = true;
    private Map<TypeNameMatch, Long> fTimestampMapping = new HashMap<TypeNameMatch, Long>();
    private final IElementChangedListener fDeltaListener;
    private final UpdateJob fUpdateJob;
    private static final String FILENAME = "OpenTypeHistory";
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_HANDLE = "handle";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final String NODE_TIMESTAMP = "timestamp";

    public static synchronized OpenTypeHistory getInstance(IDLTKUILanguageToolkit toolkit) {
        if (sToolkitHistory.containsKey(toolkit)) {
            return sToolkitHistory.get(toolkit);
        }
        OpenTypeHistory his = new OpenTypeHistory(toolkit);
        sToolkitHistory.put(toolkit, his);
        return his;
    }

    private OpenTypeHistory(IDLTKUILanguageToolkit toolkit) {
        super(FILENAME + toolkit.getCoreToolkit().getNatureId().replace('.', '_') + ".xml", NODE_ROOT, NODE_TYPE_INFO);
        this.load();
        this.fDeltaListener = new TypeHistoryDeltaListener();
        DLTKCore.addElementChangedListener((IElementChangedListener)this.fDeltaListener);
        DLTKUIPlugin.getDefault().addShutdownListener(this);
        this.fUpdateJob = new UpdateJob();
        this.fUpdateJob.setPriority(20);
        this.fTypeFilter = new TypeFilter(toolkit);
    }

    public void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    public boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    public void checkConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        if (this.fUpdateJob.getState() == 4) {
            try {
                Job.getJobManager().join((Object)FAMILY, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        this.internalCheckConsistency(monitor);
    }

    public synchronized boolean contains(TypeNameMatch type) {
        return super.contains(type);
    }

    public synchronized void accessed(TypeNameMatch info) {
        if (!this.fTimestampMapping.containsKey(info)) {
            this.fTimestampMapping.put(info, this.getContainerTimestamp(info));
        }
        super.accessed(info);
    }

    public synchronized TypeNameMatch remove(TypeNameMatch info) {
        this.fTimestampMapping.remove(info);
        return (TypeNameMatch)super.remove(info);
    }

    public synchronized void replace(TypeNameMatch old, TypeNameMatch newMatch) {
        this.fTimestampMapping.remove(old);
        this.fTimestampMapping.put(newMatch, this.getContainerTimestamp(newMatch));
        super.remove(old);
        super.accessed(newMatch);
    }

    public synchronized TypeNameMatch[] getTypeInfos() {
        Collection values = this.getValues();
        int size = values.size();
        TypeNameMatch[] result = new TypeNameMatch[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (TypeNameMatch)iter.next();
            --i;
        }
        return result;
    }

    public synchronized TypeNameMatch[] getFilteredTypeInfos(TypeInfoFilter filter) {
        Collection values = this.getValues();
        ArrayList<TypeNameMatch> result = new ArrayList<TypeNameMatch>();
        for (TypeNameMatch type : values) {
            if (type == null || filter != null && !filter.matchesHistoryElement(type) || this.fTypeFilter.isFiltered(type.getFullyQualifiedName())) continue;
            result.add(type);
        }
        Collections.reverse(result);
        return result.toArray(new TypeNameMatch[result.size()]);
    }

    @Override
    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        this.fNeedsConsistencyCheck = true;
        ArrayList typesToCheck = new ArrayList(this.getKeys());
        monitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, typesToCheck.size());
        monitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        for (TypeNameMatch type : typesToCheck) {
            if (type == null) continue;
            long currentTimestamp = this.getContainerTimestamp(type);
            Long lastTested = this.fTimestampMapping.get(type);
            if (lastTested != null && currentTimestamp != -1L && currentTimestamp == lastTested && !this.isContainerDirty(type)) continue;
            try {
                IType jType = type.getType();
                if (jType == null || !jType.exists()) {
                    this.remove(type);
                } else {
                    int modifiers = jType.getFlags();
                    if (modifiers != type.getModifiers()) {
                        this.replace(type, SearchEngine.createTypeNameMatch((IType)jType, (int)modifiers));
                    } else {
                        this.fTimestampMapping.put(type, currentTimestamp);
                    }
                }
            }
            catch (ModelException modelException) {
                this.remove(type);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        monitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    private long getContainerTimestamp(TypeNameMatch match) {
        try {
            IType type = match.getType();
            IResource resource = type.getResource();
            if (resource != null) {
                IModelElement element;
                IFileInfo info;
                URI location = resource.getLocationURI();
                if (location != null && (info = EFS.getStore((URI)location).fetchInfo()).exists() && (element = DLTKCore.create((IResource)resource)) != null && element.exists()) {
                    return info.getLastModified();
                }
            } else {
                IFileInfo info;
                IProjectFragment root = match.getProjectFragment();
                if (root.exists() && (info = EFS.getLocalFileSystem().getStore(root.getPath()).fetchInfo()).exists()) {
                    return info.getLastModified();
                }
            }
        }
        catch (CoreException coreException) {}
        return -1L;
    }

    public boolean isContainerDirty(TypeNameMatch match) {
        ITextFileBufferManager manager;
        ITextFileBuffer textFileBuffer;
        ISourceModule cu = match.getType().getSourceModule();
        if (cu == null) {
            return false;
        }
        IResource resource = cu.getResource();
        if (resource != null && (textFileBuffer = (manager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(resource.getFullPath(), LocationKind.NORMALIZE)) != null) {
            return textFileBuffer.isDirty();
        }
        return false;
    }

    public void shutdown() {
        DLTKCore.removeElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.save();
    }

    @Override
    protected Object createFromElement(Element type) {
        String handle = type.getAttribute(NODE_HANDLE);
        if (handle == null) {
            return null;
        }
        IModelElement element = DLTKCore.create((String)handle);
        if (!(element instanceof IType)) {
            return null;
        }
        int modifiers = 0;
        try {
            modifiers = Integer.parseInt(type.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {}
        TypeNameMatch info = SearchEngine.createTypeNameMatch((IType)((IType)element), (int)modifiers);
        long timestamp = -1L;
        String timestampValue = type.getAttribute(NODE_TIMESTAMP);
        if (timestampValue != null && timestampValue.length() > 0) {
            try {
                timestamp = Long.parseLong(timestampValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (timestamp != -1L) {
            this.fTimestampMapping.put(info, timestamp);
        }
        return info;
    }

    @Override
    protected void setAttributes(Object object, Element typeElement) {
        TypeNameMatch type = (TypeNameMatch)object;
        String handleId = type.getType().getHandleIdentifier();
        typeElement.setAttribute(NODE_HANDLE, handleId);
        typeElement.setAttribute(NODE_MODIFIERS, Integer.toString(type.getModifiers()));
        Long timestamp = this.fTimestampMapping.get(type);
        if (timestamp == null) {
            typeElement.setAttribute(NODE_TIMESTAMP, Long.toString(-1L));
        } else {
            typeElement.setAttribute(NODE_TIMESTAMP, timestamp.toString());
        }
    }

    private class TypeHistoryDeltaListener
    implements IElementChangedListener {
        private TypeHistoryDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.processDelta(event.getDelta())) {
                OpenTypeHistory.this.markAsInconsistent();
            }
        }

        private boolean processDelta(IModelElementDelta delta) {
            IModelElement elem = delta.getElement();
            boolean isChanged = delta.getKind() == 4;
            boolean isRemoved = delta.getKind() == 2;
            switch (elem.getElementType()) {
                case 2: {
                    if (isRemoved || isChanged && (delta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 3: {
                    if (isRemoved || isChanged && ((delta.getFlags() & 0x8000) != 0 || (delta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 7: {
                    if (isChanged && (delta.getFlags() & 2) != 0) {
                        return true;
                    }
                }
                case 1: 
                case 4: {
                    if (isRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!ScriptModelUtil.isPrimary((ISourceModule)((ISourceModule)elem))) {
                        return false;
                    }
                    if (isRemoved || isChanged && this.isUnknownStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int flags) {
            if ((flags & 1) == 0) {
                return false;
            }
            return (flags & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IModelElementDelta delta) {
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private class UpdateJob
    extends Job {
        public UpdateJob() {
            super(CorextMessages.TypeInfoHistory_consistency_check);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OpenTypeHistory.this.internalCheckConsistency(monitor);
            return new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return FAMILY.equals(family);
        }
    }
}

