/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;

public class RubyTypeDocumentationProvider
implements IScriptDocumentationProvider {
    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        ISourceModule module = (ISourceModule)element.getAncestor(5);
        if (module != null) {
            try {
                BasicContext context;
                ExpressionTypeGoal goal;
                DLTKTypeInferenceEngine engine;
                IEvaluatedType type;
                ModuleDeclaration unit = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
                ISourceRange sourceRange = element.getSourceRange();
                ASTNode minimalNode = ASTUtils.findMinimalNode((ModuleDeclaration)unit, (int)sourceRange.getOffset(), (int)(sourceRange.getOffset() + sourceRange.getLength()));
                if (minimalNode != null && minimalNode != unit && (type = (engine = new DLTKTypeInferenceEngine()).evaluateType((AbstractTypeGoal)(goal = new ExpressionTypeGoal((IContext)(context = new BasicContext(module, unit)), minimalNode)), 500)) instanceof RubyClassType) {
                    RubyClassType rubyClassType = (RubyClassType)type;
                    return new StringReader("Inferenced type: " + rubyClassType.getModelKey());
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Reader getInfo(String content) {
        return null;
    }
}

