/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.dltk.formatter.AbstractFormatterNodeBuilder;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;
import org.eclipse.dltk.ruby.formatter.internal.DumpStackOnly;
import org.eclipse.dltk.ruby.formatter.internal.Messages;
import org.eclipse.dltk.ruby.formatter.internal.RubyFormatterPlugin;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterArrayNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterAtBeginNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterAtEndNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterBeginNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterCaseNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterClassNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterDoNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterElseIfNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterEnsureNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterForNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterHashNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterHereDocNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterIfElseNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterIfEndNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterIfNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterMethodNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterModifierNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterModuleNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterRDocNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterRequireNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterRescueElseNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterRescueNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterRootNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterStringNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterUntilNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterWhenElseNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterWhenNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterWhileNode;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.CommentNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.ext.ElseNode;
import org.jruby.ast.ext.HeredocNode;
import org.jruby.ast.ext.PreExeNode;
import org.jruby.ast.visitor.AbstractVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.parser.RubyParserResult;

public class RubyFormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    protected static final Comparator<Node> POSITION_COMPARATOR = (node1, node2) -> node1.getStartOffset() - node2.getStartOffset();

    public IFormatterContainerNode build(RubyParserResult result, final IFormatterDocument document) {
        FormatterRootNode root = new FormatterRootNode(document);
        this.start((IFormatterContainerNode)root);
        result.getAST().accept(new AbstractVisitor(){

            @Override
            protected Instruction visitNode(Node visited) {
                this.visitChildren(visited);
                return null;
            }

            @Override
            public Instruction visitClassNode(ClassNode visited) {
                FormatterClassNode classNode = new FormatterClassNode(document);
                classNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getClassKeyword()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)classNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)classNode, visited.getEnd().getPosition().getStartOffset());
                classNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitSClassNode(SClassNode visited) {
                FormatterClassNode classNode = new FormatterClassNode(document);
                classNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getClassKeyword()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)classNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)classNode, visited.getEnd().getPosition().getStartOffset());
                classNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitModuleNode(ModuleNode visited) {
                FormatterModuleNode moduleNode = new FormatterModuleNode(document);
                moduleNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getKeyword()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)moduleNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)moduleNode, visited.getEnd().getPosition().getStartOffset());
                moduleNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitDefnNode(DefnNode visited) {
                return this.visitMethodDefNode(visited);
            }

            @Override
            public Instruction visitDefsNode(DefsNode visited) {
                return this.visitMethodDefNode(visited);
            }

            private Instruction visitMethodDefNode(MethodDefNode visited) {
                FormatterMethodNode methodNode = new FormatterMethodNode(document);
                methodNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getStartOffset(), visited.getNameNode().getEndOffset()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)methodNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)methodNode, visited.getEnd().getPosition().getStartOffset());
                methodNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitWhileNode(WhileNode visited) {
                if (!visited.isBlock()) {
                    this.visitChildren(visited);
                    return null;
                }
                FormatterWhileNode whileNode = new FormatterWhileNode(document);
                whileNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getKeyword()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)whileNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)whileNode, visited.getEnd().getPosition().getStartOffset());
                whileNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitIterNode(IterNode visited) {
                FormatterDoNode forNode = new FormatterDoNode(document);
                forNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getBegin()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)forNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)forNode, visited.getEnd().getPosition().getStartOffset());
                forNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitForNode(ForNode visited) {
                FormatterForNode forNode = new FormatterForNode(document);
                forNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getBegin()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)forNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)forNode, visited.getEnd().getPosition().getStartOffset());
                forNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitUntilNode(UntilNode visited) {
                if (!visited.isBlock()) {
                    this.visitChild(visited.getBodyNode());
                    FormatterModifierNode block = new FormatterModifierNode(document);
                    block.addChild((IFormatterNode)RubyFormatterNodeBuilder.this.createTextNode(document, visited.getKeyword()));
                    RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)block);
                    this.visitChild(visited.getConditionNode());
                    RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)block, visited.getConditionNode().getEndOffset());
                    return null;
                }
                FormatterUntilNode untilNode = new FormatterUntilNode(document);
                untilNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getKeyword()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)untilNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)untilNode, visited.getEnd().getPosition().getStartOffset());
                untilNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitCaseNode(CaseNode visited) {
                FormatterCaseNode caseNode = new FormatterCaseNode(document);
                int caseEnd = visited.getCaseKeyword().getPosition().getEndOffset();
                caseNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getStartOffset(), caseEnd));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)caseNode);
                Node branch = visited.getFirstWhenNode();
                while (branch != null) {
                    if (branch instanceof WhenNode) {
                        WhenNode whenBranch = (WhenNode)branch;
                        FormatterWhenNode whenNode = new FormatterWhenNode(document);
                        whenNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, branch.getStartOffset(), whenBranch.getExpressionNodes().getEndOffset()));
                        RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)whenNode);
                        this.visitChild(whenBranch.getBodyNode());
                        branch = ((WhenNode)branch).getNextCase();
                        RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)whenNode, branch != null ? branch.getStartOffset() : visited.getEnd().getPosition().getStartOffset());
                        continue;
                    }
                    if (branch instanceof ElseNode) {
                        ElseNode elseBranch = (ElseNode)branch;
                        FormatterWhenElseNode whenElseNode = new FormatterWhenElseNode(document);
                        whenElseNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, elseBranch.getStartOffset(), elseBranch.getElseKeyword().getPosition().getEndOffset()));
                        RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)whenElseNode);
                        this.visitChild(elseBranch.getStatement());
                        RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)whenElseNode, visited.getEnd().getPosition().getStartOffset());
                        branch = null;
                        continue;
                    }
                    RubyFormatterPlugin.warn(NLS.bind((String)Messages.RubyFormatterNodeBuilder_unexpectedClassInCaseWhenExpression, (Object)branch.getClass().getName()), new DumpStackOnly());
                    break;
                }
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)caseNode, visited.getEnd().getPosition().getStartOffset());
                caseNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnd()));
                return null;
            }

            @Override
            public Instruction visitCommentNode(CommentNode visited) {
                FormatterRDocNode commentNode = new FormatterRDocNode(document, visited.getStartOffset(), visited.getEndOffset());
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)commentNode);
                return null;
            }

            @Override
            public Instruction visitIfNode(IfNode visited) {
                if (visited.isInline()) {
                    ArrayList<Node> children = new ArrayList<Node>(3);
                    if (visited.getThenBody() != null) {
                        children.add(visited.getThenBody());
                    }
                    if (visited.getElseBody() != null) {
                        children.add(visited.getElseBody());
                    }
                    if (visited.getCondition() != null) {
                        children.add(visited.getCondition());
                    }
                    if (!children.isEmpty()) {
                        Collections.sort(children, POSITION_COMPARATOR);
                        this.visitChildren(children);
                    }
                    return null;
                }
                FormatterIfNode ifNode = new FormatterIfNode(document);
                ifNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getStartOffset(), visited.getCondition().getEndOffset()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)ifNode);
                this.visitChild(visited.getFirstBody());
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)ifNode, visited.getSecondBody() != null ? visited.getSecondBody().getStartOffset() : visited.getEndKeyword().getPosition().getStartOffset());
                Node branch = visited.getSecondBody();
                while (branch != null) {
                    if (branch instanceof IfNode.ElseIf) {
                        IfNode.ElseIf elseIfBranch = (IfNode.ElseIf)branch;
                        FormatterElseIfNode elseIfNode = new FormatterElseIfNode(document);
                        elseIfNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, elseIfBranch.getStartOffset(), elseIfBranch.getCondition().getEndOffset()));
                        RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)elseIfNode);
                        this.visitChild(elseIfBranch.getFirstBody());
                        branch = ((IfNode.ElseIf)branch).getSecondBody();
                        RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)elseIfNode, branch != null ? branch.getStartOffset() : visited.getEndKeyword().getPosition().getStartOffset());
                        continue;
                    }
                    if (branch instanceof ElseNode) {
                        ElseNode elseBranch = (ElseNode)branch;
                        FormatterIfElseNode elseNode = new FormatterIfElseNode(document);
                        elseNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, elseBranch.getElseKeyword()));
                        RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)elseNode);
                        this.visitChild(elseBranch.getStatement());
                        RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)elseNode, visited.getEndKeyword().getPosition().getStartOffset());
                        branch = null;
                        continue;
                    }
                    RubyFormatterPlugin.warn(NLS.bind((String)Messages.RubyFormatterNodeBuilder_unexpectedClassInIfExpression, (Object)branch.getClass().getName()), new DumpStackOnly());
                    break;
                }
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterIfEndNode(document, visited.getEndKeyword().getPosition()));
                return null;
            }

            @Override
            public Instruction visitBeginNode(BeginNode visited) {
                FormatterBeginNode beginNode = new FormatterBeginNode(document);
                beginNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getBeginKeyword()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)beginNode);
                this.visitChild(visited.getBodyNode());
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)beginNode, visited.getEndKeyword().getPosition().getStartOffset());
                beginNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEndKeyword()));
                return null;
            }

            @Override
            public Instruction visitRescueNode(RescueNode visited) {
                if (visited.isInline()) {
                    return null;
                }
                this.visitChild(visited.getBodyNode());
                RescueBodyNode node = visited.getRescueNode();
                while (node != null) {
                    FormatterRescueNode rescueNode = new FormatterRescueNode(document);
                    rescueNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, node.getRescueKeyword().getPosition().getStartOffset(), node.getExceptionNodes() != null ? node.getExceptionNodes().getEndOffset() : node.getRescueKeyword().getPosition().getEndOffset()));
                    RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)rescueNode);
                    this.visitChild(node.getBodyNode());
                    node = node.getOptRescueNode();
                    int rescueEnd = node != null ? node.getStartOffset() : (visited.getElseNode() != null ? visited.getElseNode().getStartOffset() : -1);
                    RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)rescueNode, rescueEnd);
                }
                if (visited.getElseNode() != null) {
                    ElseNode elseBranch = (ElseNode)visited.getElseNode();
                    FormatterRescueElseNode elseNode = new FormatterRescueElseNode(document);
                    elseNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, elseBranch.getElseKeyword()));
                    RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)elseNode);
                    this.visitChild(elseBranch.getStatement());
                    RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)elseNode, -1);
                }
                return null;
            }

            @Override
            public Instruction visitEnsureNode(EnsureNode visited) {
                this.visitChild(visited.getBodyNode());
                FormatterEnsureNode ensureNode = new FormatterEnsureNode(document);
                ensureNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEnsureNode().getKeyword()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)ensureNode);
                this.visitChild(visited.getEnsureNode().getStatement());
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)ensureNode, -1);
                return null;
            }

            @Override
            public Instruction visitPreExeNode(PreExeNode visited) {
                FormatterAtBeginNode endNode = new FormatterAtBeginNode(document);
                endNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getKeyword().getPosition().getStartOffset(), visited.getLeftBrace().getPosition().getEndOffset()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)endNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)endNode, visited.getRightBrace().getPosition().getStartOffset());
                endNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getRightBrace()));
                return null;
            }

            @Override
            public Instruction visitPostExeNode(PostExeNode visited) {
                FormatterAtEndNode endNode = new FormatterAtEndNode(document);
                endNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getEndKeyword().getPosition().getStartOffset(), visited.getLeftBrace().getPosition().getEndOffset()));
                RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)endNode);
                this.visitChildren(visited);
                RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)endNode, visited.getRightBrace().getPosition().getStartOffset());
                endNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getRightBrace()));
                return null;
            }

            @Override
            public Instruction visitStrNode(StrNode visited) {
                FormatterStringNode strNode = new FormatterStringNode(document, visited.getStartOffset(), visited.getEndOffset());
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return null;
            }

            @Override
            public Instruction visitDStrNode(DStrNode visited) {
                FormatterStringNode strNode = new FormatterStringNode(document, visited.getStartOffset(), visited.getEndOffset());
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return null;
            }

            @Override
            public Instruction visitRegexpNode(RegexpNode visited) {
                FormatterStringNode strNode = new FormatterStringNode(document, visited.getStartOffset(), visited.getEndOffset());
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return null;
            }

            @Override
            public Instruction visitDRegxNode(DRegexpNode visited) {
                FormatterStringNode strNode = new FormatterStringNode(document, visited.getStartOffset(), visited.getEndOffset());
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return null;
            }

            @Override
            public Instruction visitXStrNode(XStrNode visited) {
                FormatterStringNode strNode = new FormatterStringNode(document, visited.getStartOffset(), visited.getEndOffset());
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return null;
            }

            @Override
            public Instruction visitHeredocNode(HeredocNode visited) {
                FormatterHereDocNode heredocNode = new FormatterHereDocNode(document, visited.getStartOffset(), visited.getEndOffset(), visited.isIndent());
                RubyFormatterNodeBuilder.this.addChild((IFormatterNode)heredocNode);
                heredocNode.setContentRegion(RubyFormatterNodeBuilder.createRegion(visited.getContent().getPosition()));
                heredocNode.setEndMarkerRegion(RubyFormatterNodeBuilder.createRegion(visited.getEndMarker().getPosition()));
                return null;
            }

            @Override
            public Instruction visitFCallNode(FCallNode visited) {
                if (this.isRequireMethod(visited)) {
                    FormatterRequireNode requireNode = new FormatterRequireNode(document, visited.getStartOffset(), visited.getEndOffset());
                    RubyFormatterNodeBuilder.this.addChild((IFormatterNode)requireNode);
                    return null;
                }
                return super.visitFCallNode(visited);
            }

            @Override
            public Instruction visitArrayNode(ArrayNode visited) {
                if (visited.getLeftBracketPosition() != null && visited.getRightBracketPosition() != null) {
                    FormatterArrayNode arrayNode = new FormatterArrayNode(document);
                    arrayNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getLeftBracketPosition()));
                    RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)arrayNode);
                    ISourcePosition right = visited.getRightBracketPosition().getPosition();
                    RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)arrayNode, right.getStartOffset());
                    arrayNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, right));
                    return null;
                }
                return super.visitArrayNode(visited);
            }

            @Override
            public Instruction visitHashNode(HashNode visited) {
                if (visited.getLeftBrace() != null && visited.getRightBrace() != null) {
                    FormatterHashNode hashNode = new FormatterHashNode(document);
                    hashNode.setBegin(RubyFormatterNodeBuilder.this.createTextNode(document, visited.getLeftBrace()));
                    RubyFormatterNodeBuilder.this.push((IFormatterContainerNode)hashNode);
                    ISourcePosition right = visited.getRightBrace().getPosition();
                    RubyFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)hashNode, right.getStartOffset());
                    hashNode.setEnd(RubyFormatterNodeBuilder.this.createTextNode(document, right));
                    return null;
                }
                return super.visitHashNode(visited);
            }

            private boolean isRequireMethod(FCallNode call) {
                return "require".equals(call.getName()) && call.getArgsNode() instanceof ArrayNode;
            }

            private void visitChildren(Node visited) {
                List children = visited.childNodes();
                if (!children.isEmpty()) {
                    this.visitChildren(children);
                }
            }

            private void visitChildren(List<Node> children) {
                for (Node child : children) {
                    this.visitChild(child);
                }
            }

            private void visitChild(Node child) {
                if (child != null && this.isVisitable(child)) {
                    child.accept(this);
                }
            }

            private boolean isVisitable(Node node) {
                return !(node instanceof ArgumentNode) && node.getClass() != ListNode.class;
            }
        });
        this.checkedPop((IFormatterContainerNode)root, document.getLength());
        return root;
    }

    private IFormatterTextNode createTextNode(IFormatterDocument document, ISourcePositionHolder holder) {
        return this.createTextNode(document, holder.getPosition());
    }

    private IFormatterTextNode createTextNode(IFormatterDocument document, ISourcePosition position) {
        return this.createTextNode(document, position.getStartOffset(), position.getEndOffset());
    }

    private static IRegion createRegion(ISourcePosition position) {
        return new Region(position.getStartOffset(), position.getEndOffset() - position.getStartOffset());
    }
}

