/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core;

import java.util.Collections;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.RecordMember;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;

public class RRecordMember
implements IRRecordMember {
    private final String name;
    private final IRType type;
    private final Object source;

    public RRecordMember(String name, IRType type, Object member) {
        this.name = name;
        this.type = type;
        this.source = member;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRType getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.source instanceof RecordMember && ((RecordMember)this.source).isOptional();
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.type + (this.isOptional() ? "=" : "");
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RRecordMember) {
            RRecordMember other = (RRecordMember)obj;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }
        return false;
    }

    @Override
    public Visibility getVisibility() {
        if (this.source instanceof IModelBuilder.IMember) {
            return ((IModelBuilder.IMember)this.source).getVisibility();
        }
        return Visibility.PUBLIC;
    }

    @Override
    public IRTypeDeclaration getDeclaringType() {
        return null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public Set<IProblemCategory> getSuppressedWarnings() {
        return Collections.emptySet();
    }

    @Override
    public boolean isSuppressed(IProblemIdentifier problemIdentifier) {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return this.source instanceof IModelBuilder.IMember && ((IModelBuilder.IMember)this.source).isDeprecated() || this.source instanceof Member && ((Member)this.source).isDeprecated();
    }

    @Override
    public Object getSource() {
        return this.source;
    }
}

