/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class ScriptCompletionProposal
extends AbstractScriptCompletionProposal {
    public ScriptCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, relevance, false);
    }

    public ScriptCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, boolean indoc) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.setReplacementString(replacementString);
        this.setReplacementOffset(replacementOffset);
        this.setReplacementLength(replacementLength);
        this.setImage(image);
        this.setDisplayString(displayString == null ? replacementString : displayString);
        this.setRelevance(relevance);
        this.setCursorPosition(replacementString.length());
        this.setInDoc(indoc);
        this.setSortString(displayString == null ? replacementString : displayString);
    }

    @Override
    protected boolean isValidPrefix(String prefix) {
        String word = this.getDisplayString();
        if (this.isInDoc()) {
            int idx = word.indexOf("{@link ");
            if (idx == 0) {
                word = word.substring(7);
            } else {
                idx = word.indexOf("{@value ");
                if (idx == 0) {
                    word = word.substring(8);
                }
            }
        }
        return this.isPrefix(prefix, word);
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String string = this.getReplacementString();
        int pos = string.indexOf(40);
        if (pos > 0) {
            return string.subSequence(0, pos);
        }
        return string;
    }
}

