/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.codeassist;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.utils.ASTUtil;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.python.internal.core.parser.PythonParseUtils;

public class PythonASTUtil
extends ASTUtil {
    public static void extendStatements(ASTNode node, String content) {
        List statements = PythonASTUtil.getStatements((ASTNode)node);
        if (statements != null) {
            int len = statements.size();
            int i = 0;
            while (i < len) {
                ASTNode nde = (ASTNode)statements.get(i);
                PythonASTUtil.extendStatement(nde, content);
                PythonASTUtil.extendStatements(nde, content);
                ++i;
            }
        }
    }

    public static void extendStatement(ASTNode node, String content) {
        int newValueStart = PythonASTUtil.startLineOrSymbol(node, content);
        int newValueEnd = PythonASTUtil.endLineOrSymbol(node, content);
        if (DLTKCore.DEBUG_COMPLETION && node.sourceEnd() == newValueEnd) {
            node.sourceStart();
        }
        node.setStart(newValueStart);
        node.setEnd(newValueEnd);
    }

    public static int endLineOrSymbol(ASTNode node, String content) {
        return PythonParseUtils.endLineOrSymbol(node.sourceEnd(), content);
    }

    public static int startLineOrSymbol(ASTNode node, String content) {
        return PythonParseUtils.startLineOrSymbol(node.sourceStart(), content);
    }
}

