/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoResourceSet;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class TypeCache {
    private final URI baseURI;
    private final TypeCacheResourceSet resourceSet;
    private final ThreadLocal<ThreadState> threads = new ThreadLocal<ThreadState>(){

        @Override
        protected ThreadState initialValue() {
            return new ThreadState();
        }
    };

    public TypeCache(String scheme, String authority) {
        this(URI.createHierarchicalURI((String)scheme, (String)authority, null, null, null));
    }

    public TypeCache(URI baseURI) {
        Assert.isLegal((boolean)baseURI.isHierarchical(), (String)"TypeCache baseURI must be hierarchical");
        this.baseURI = baseURI;
        this.resourceSet = new TypeCacheResourceSet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Type addType(String bucket, Type type) {
        TypeCacheResource resource;
        Assert.isLegal((type.eResource() == null ? 1 : 0) != 0);
        Assert.isLegal((!type.eIsProxy() ? 1 : 0) != 0);
        TypeCacheResource typeCacheResource = resource = this.getResource(bucket, true);
        synchronized (typeCacheResource) {
            String name = type.getName();
            Type previous = resource.types.get(name);
            if (previous != null) {
                return previous;
            }
            resource.types.put(name, type);
            resource.getContents().add((Object)type);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeCacheResource getResource(String bucket, boolean loadOnDemand) {
        TypeCacheResourceSet typeCacheResourceSet = this.resourceSet;
        synchronized (typeCacheResourceSet) {
            return (TypeCacheResource)this.resourceSet.getResource(this.getURI(bucket), loadOnDemand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Type findType(String context, String typeName) {
        TypeCacheResource resource = this.getResource(context, false);
        if (resource != null) {
            TypeCacheResource typeCacheResource = resource;
            synchronized (typeCacheResource) {
                Type type = resource.types.get(typeName);
                if (type != null) {
                    return type;
                }
            }
        }
        ThreadState state = this.threads.get();
        ++state.activeOperations;
        try {
            String[] accessible;
            String[] stringArray = accessible = this.getAccessibleBuckets(context);
            int n = accessible.length;
            int n2 = 0;
            while (n2 < n) {
                String ac = stringArray[n2];
                TypeCacheResource ar = this.getResource(ac, false);
                if (ar != null) {
                    TypeCacheResource typeCacheResource = ar;
                    synchronized (typeCacheResource) {
                        Type type = ar.types.get(typeName);
                        if (type != null) {
                            Type type2 = type;
                            return type2;
                        }
                    }
                }
                ++n2;
            }
            Type type = this.createType(context, typeName);
            return type;
        }
        finally {
            --state.activeOperations;
        }
    }

    protected String[] getAccessibleBuckets(String context) {
        return CharOperation.NO_STRINGS;
    }

    protected abstract Type createType(String var1, String var2);

    protected final Type getType(String context, String typeName) {
        return this.getType(context, typeName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Type getType(String context, String typeName, boolean force) {
        Type type = TypeInfoModelLoader.getInstance().getType(typeName);
        if (type != null) {
            return type;
        }
        TypeCacheResource resource = this.getResource(context, false);
        if (resource != null) {
            TypeCacheResource typeCacheResource = resource;
            synchronized (typeCacheResource) {
                type = resource.types.get(typeName);
                if (type != null) {
                    return type;
                }
            }
        }
        ThreadState state = this.threads.get();
        if (!force && state.activeOperations != 0) {
            return TypeUtil.createProxy(typeName);
        }
        ++state.activeOperations;
        try {
            String[] accessible;
            String[] stringArray = accessible = this.getAccessibleBuckets(context);
            int n = accessible.length;
            int n2 = 0;
            while (n2 < n) {
                String bucket = stringArray[n2];
                resource = this.getResource(bucket, false);
                if (resource != null) {
                    TypeCacheResource typeCacheResource = resource;
                    synchronized (typeCacheResource) {
                        type = resource.types.get(typeName);
                        if (type != null) {
                            Type type2 = type;
                            return type2;
                        }
                    }
                }
                ++n2;
            }
            Type type3 = this.createType(context, typeName);
            return type3;
        }
        finally {
            --state.activeOperations;
        }
    }

    protected SimpleType getTypeRef(String context, String typeName) {
        return TypeUtil.ref(this.getType(context, typeName));
    }

    private URI getURI(String bucket) {
        if (bucket == null || bucket.length() == 0) {
            return this.baseURI;
        }
        return this.baseURI.appendSegment(bucket);
    }

    private static boolean isPrefixOf(URI base, URI uri) {
        int segmentCount;
        if (uri.isHierarchical() && base.scheme().equals(uri.scheme()) && base.authority().equals(uri.authority()) && (segmentCount = base.segmentCount()) <= uri.segmentCount()) {
            int i = 0;
            while (i < segmentCount) {
                if (!base.segment(i).equals(uri.segment(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    String getContextOf(Resource resourceContext) {
        URI uri = resourceContext.getURI();
        if (uri != null && TypeCache.isPrefixOf(this.baseURI, uri)) {
            if (this.baseURI.segmentCount() == uri.segmentCount()) {
                return "";
            }
            return uri.segment(this.baseURI.segmentCount());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TypeCacheResourceSet typeCacheResourceSet = this.resourceSet;
        synchronized (typeCacheResourceSet) {
            EList resources = this.resourceSet.getResources();
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                Resource resource;
                Resource resource2 = resource = (Resource)iterator.next();
                synchronized (resource2) {
                    resource.unload();
                }
            }
            resources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String bucket) {
        TypeCacheResource resource;
        Object object = this.resourceSet;
        synchronized (object) {
            resource = this.getResource(bucket, false);
        }
        if (resource != null) {
            object = resource;
            synchronized (object) {
                resource.unload();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardingTreeIterator<E>
    implements TreeIterator<E> {
        private final Iterator<E> delegate;

        public ForwardingTreeIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public E next() {
            return this.delegate.next();
        }

        public void remove() {
            this.delegate.remove();
        }

        public void prune() {
        }
    }

    static class ThreadState {
        int activeOperations;

        ThreadState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeCacheResource
    extends ResourceImpl {
        final Map<String, Type> types = new HashMap<String, Type>();

        public TypeCacheResource(URI uri) {
            super(uri);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + '@' + Integer.toHexString(((Object)((Object)this)).hashCode()) + "@" + this.uri;
        }

        protected void doUnload() {
            this.types.clear();
            super.doUnload();
        }

        protected TreeIterator<EObject> getAllProperContents(List<EObject> contents) {
            return new ForwardingTreeIterator<EObject>(contents.iterator());
        }
    }

    private static class TypeCacheResourceSet
    extends ResourceSetImpl
    implements TypeInfoResourceSet {
        private final TypeCache cache;

        public TypeCacheResourceSet(TypeCache cache) {
            this.cache = cache;
            this.setURIResourceMap(new HashMap());
        }

        public Resource createResource(URI uri, String contentType) {
            TypeCacheResource resource = new TypeCacheResource(uri);
            this.getResources().add((Object)resource);
            return resource;
        }

        protected void demandLoadHelper(Resource resource) {
            resource.getContents().clear();
        }

        public EObject resolve(InternalEObject proxy, EObject objectContext, Resource resourceContext) {
            URI uri = proxy.eProxyURI();
            if (TypeUtil.isTypeProxy(uri)) {
                return this.cache.getType(this.cache.getContextOf(resourceContext), URI.decode((String)uri.fragment()), true);
            }
            return EcoreUtil.resolve((EObject)proxy, (ResourceSet)this);
        }
    }
}

