/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.IXMLExpression;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.XmlFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlLiteral
extends Expression
implements IXMLExpression {
    private List<XmlFragment> fragments = null;

    public XmlLiteral(JSNode parent) {
        super(parent);
    }

    public void addFragment(XmlFragment fragment) {
        this.fragments.add(fragment);
    }

    public List<XmlFragment> getFragments() {
        return this.fragments != null ? this.fragments : Collections.emptyList();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.fragments != null) {
                for (XmlFragment fragment : this.fragments) {
                    fragment.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    @Override
    public String toSourceString(String indentationString) {
        StringBuilder sb = new StringBuilder();
        for (XmlFragment fragment : this.fragments) {
            sb.append(fragment.toSourceString(""));
        }
        return sb.toString();
    }

    public void setFragments(List<XmlFragment> fragments) {
        this.fragments = fragments != null ? new ArrayList<XmlFragment>(fragments) : null;
    }
}

