/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.internal;

import org.eclipse.dltk.ruby.formatter.lexer.ILexerReader;
import org.eclipse.dltk.ruby.formatter.lexer.StringLexerReader;
import org.eclipse.dltk.ui.formatter.FormatterSyntaxProblemException;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;

public class RubyParser {
    private static final String FILENAME = "";

    public static RubyParserResult parse(String content) throws FormatterSyntaxProblemException {
        return RubyParser.parse(new StringLexerReader(content));
    }

    public static RubyParserResult parse(ILexerReader content) throws FormatterSyntaxProblemException {
        RubyParserConfiguration configuration = new RubyParserConfiguration();
        RubyParserPool parserPool = RubyParserPool.getInstance();
        DefaultRubyParser parser = parserPool.borrowParser();
        try {
            RubyParserResult result;
            parser.setWarnings(new NullWarnings());
            LexerSource source = LexerSource.getSource(FILENAME, content);
            RubyParserResult rubyParserResult = result = parser.parse(configuration, source);
            return rubyParserResult;
        }
        catch (SyntaxException e) {
            throw new FormatterSyntaxProblemException(e.getMessage(), (Throwable)e);
        }
        finally {
            parserPool.returnParser(parser);
        }
    }
}

