/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonSuperTypeFinder {
    public static IRType evaluate(ITypeSystem typeSystem, Collection<? extends IRType> types) {
        IRType type;
        if (types.isEmpty()) {
            return RTypes.any();
        }
        if (types.size() == 1 && !((type = CommonSuperTypeFinder.getSingleItem(types)) instanceof IRUnionType)) {
            return type;
        }
        State state = new State();
        state.addAll(types);
        return state.find(typeSystem);
    }

    @Nullable
    public static IRTypeDeclaration leastCommonSuperType(List<IRTypeDeclaration> declarations) {
        if (declarations.isEmpty()) {
            return null;
        }
        if (declarations.size() == 1) {
            return declarations.get(0);
        }
        ArrayList<IRTypeDeclaration> hierarchy = new ArrayList<IRTypeDeclaration>();
        IRTypeDeclaration d = declarations.get(0);
        do {
            hierarchy.add(d);
        } while ((d = d.getSuperType()) != null);
        Collections.reverse(hierarchy);
        int i = 1;
        while (i < declarations.size()) {
            block6: {
                IRTypeDeclaration declaration = declarations.get(i);
                do {
                    int index;
                    if ((index = hierarchy.lastIndexOf(declaration)) < 0) continue;
                    int j = hierarchy.size();
                    while (--j > index) {
                        hierarchy.remove(j);
                    }
                    break block6;
                } while ((declaration = declaration.getSuperType()) != null);
                return RTypes.OBJECT.getDeclaration();
            }
            ++i;
        }
        return (IRTypeDeclaration)hierarchy.get(hierarchy.size() - 1);
    }

    static <T> T getSingleItem(Collection<T> values) {
        assert (values.size() == 1);
        if (values instanceof List) {
            return (T)((List)values).get(0);
        }
        return (T)values.toArray()[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class State {
        int anyCount;
        final Set<IRSimpleType> simpleTypes = new HashSet<IRSimpleType>();
        final Set<IRClassType> classTypes = new HashSet<IRClassType>();
        final Set<IRArrayType> arrayTypes = new HashSet<IRArrayType>();
        final Set<IRMapType> mapTypes = new HashSet<IRMapType>();
        final Set<IRLocalType> localTypes = new HashSet<IRLocalType>();
        final Set<IRRecordType> recordTypes = new HashSet<IRRecordType>();
        final Set<IRType> others = new HashSet<IRType>();

        State() {
        }

        void addAll(Collection<? extends IRType> types) {
            for (IRType iRType : types) {
                this.add(iRType);
            }
        }

        void add(IRType type) {
            if (type == RTypes.none() || type == RTypes.undefined()) {
                return;
            }
            if (type == RTypes.any()) {
                ++this.anyCount;
            } else if (type instanceof IRUnionType) {
                this.addAll(((IRUnionType)type).getTargets());
            } else if (type instanceof IRArrayType) {
                this.arrayTypes.add((IRArrayType)type);
            } else if (type instanceof IRSimpleType) {
                this.simpleTypes.add((IRSimpleType)type);
            } else if (type instanceof IRClassType) {
                this.classTypes.add((IRClassType)type);
            } else if (type instanceof IRMapType) {
                this.mapTypes.add((IRMapType)type);
            } else if (type instanceof IRLocalType) {
                this.localTypes.add((IRLocalType)type);
            } else if (type instanceof IRRecordType) {
                this.recordTypes.add((IRRecordType)type);
            } else {
                this.others.add(type);
            }
        }

        private int countCollections() {
            int result = 0;
            if (!this.simpleTypes.isEmpty()) {
                ++result;
            }
            if (!this.classTypes.isEmpty()) {
                ++result;
            }
            if (!this.arrayTypes.isEmpty()) {
                ++result;
            }
            if (!this.mapTypes.isEmpty()) {
                ++result;
            }
            if (!this.localTypes.isEmpty()) {
                ++result;
            }
            if (!this.recordTypes.isEmpty()) {
                ++result;
            }
            if (!this.others.isEmpty()) {
                ++result;
            }
            return result;
        }

        private boolean areJavaScriptObjects(Collection<? extends IRType> types) {
            for (IRType iRType : types) {
                if (iRType.isJavaScriptObject()) continue;
                return false;
            }
            return true;
        }

        private boolean areJavaScriptObjects() {
            return this.areJavaScriptObjects(this.simpleTypes) && this.areJavaScriptObjects(this.classTypes) && this.areJavaScriptObjects(this.others);
        }

        IRType find(ITypeSystem typeSystem) {
            if (this.anyCount != 0) {
                return RTypes.any();
            }
            if (this.countCollections() != 1) {
                return this.areJavaScriptObjects() ? RTypes.OBJECT : RTypes.any();
            }
            if (!this.simpleTypes.isEmpty()) {
                if (this.simpleTypes.size() == 1) {
                    return CommonSuperTypeFinder.getSingleItem(this.simpleTypes);
                }
                ArrayList<IRTypeDeclaration> declarations = new ArrayList<IRTypeDeclaration>();
                for (IRSimpleType type : this.simpleTypes) {
                    declarations.add(type.getDeclaration());
                }
                IRTypeDeclaration common = CommonSuperTypeFinder.leastCommonSuperType(declarations);
                return common != null ? RTypes.simple(common) : RTypes.any();
            }
            if (!this.classTypes.isEmpty()) {
                if (this.classTypes.size() == 1) {
                    return CommonSuperTypeFinder.getSingleItem(this.classTypes);
                }
                ArrayList<IRTypeDeclaration> declarations = new ArrayList<IRTypeDeclaration>();
                for (IRClassType type : this.classTypes) {
                    if (type.getDeclaration() == null) {
                        return type;
                    }
                    declarations.add(type.getDeclaration());
                }
                return RTypes.classType(CommonSuperTypeFinder.leastCommonSuperType(declarations));
            }
            if (!this.arrayTypes.isEmpty()) {
                if (this.arrayTypes.size() == 1) {
                    return CommonSuperTypeFinder.getSingleItem(this.arrayTypes);
                }
                HashSet<IRType> itemTypes = new HashSet<IRType>();
                for (IRArrayType type : this.arrayTypes) {
                    itemTypes.add(type.getItemType());
                }
                return RTypes.arrayOf(typeSystem, CommonSuperTypeFinder.evaluate(typeSystem, itemTypes));
            }
            if (!this.mapTypes.isEmpty()) {
                if (this.mapTypes.size() == 1) {
                    return CommonSuperTypeFinder.getSingleItem(this.mapTypes);
                }
                HashSet<IRType> itemTypes = new HashSet<IRType>();
                for (IRMapType type : this.mapTypes) {
                    itemTypes.add(type.getValueType());
                }
                return RTypes.mapOf(RTypes.STRING, CommonSuperTypeFinder.evaluate(typeSystem, itemTypes));
            }
            if (!this.localTypes.isEmpty()) {
                if (this.localTypes.size() == 1) {
                    return CommonSuperTypeFinder.getSingleItem(this.localTypes);
                }
                HashSet<ReferenceLocation> locations = new HashSet<ReferenceLocation>();
                for (IRLocalType type : this.localTypes) {
                    locations.add(type.getReferenceLocation());
                }
                return locations.size() == 1 ? (IRType)this.localTypes.iterator().next() : RTypes.OBJECT;
            }
            if (!this.recordTypes.isEmpty()) {
                if (this.recordTypes.size() == 1) {
                    return CommonSuperTypeFinder.getSingleItem(this.recordTypes);
                }
                ArrayList<IRRecordMember> commonMembers = new ArrayList<IRRecordMember>();
                for (IRRecordType type : this.recordTypes) {
                    if (commonMembers.size() == 0) {
                        commonMembers.addAll(type.getMembers());
                        continue;
                    }
                    commonMembers.retainAll(type.getMembers());
                }
                return commonMembers.size() == 0 ? RTypes.OBJECT : RTypes.recordType(commonMembers);
            }
            assert (!this.others.isEmpty());
            if (this.others.size() == 1) {
                return CommonSuperTypeFinder.getSingleItem(this.others);
            }
            return RTypes.OBJECT;
        }
    }
}

