/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.ArrayScriptType;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.ComplexScriptType;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.StringScriptType;

public class JavaScriptTypeFactory
implements IScriptTypeFactory {
    private static final String[] atomicTypes = new String[]{"number", "boolean", "date"};
    private static final ThreadLocal<Integer> detailsLevel = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public IScriptType buildType(String type) {
        int i = 0;
        while (i < atomicTypes.length) {
            if (atomicTypes[i].equals(type)) {
                return new AtomicScriptType(type);
            }
            ++i;
        }
        if ("javaarray".equals(type) || "array".equals(type)) {
            return new ArrayScriptType(){

                protected String buildDetailString(IVariable variable) throws DebugException {
                    Integer currentLevel = (Integer)detailsLevel.get();
                    detailsLevel.set(currentLevel + 1);
                    try {
                        if (variable.getValue() instanceof IScriptValue && currentLevel < 2) {
                            IScriptValue value = (IScriptValue)variable.getValue();
                            String string = value.getType().formatDetails(value);
                            return string;
                        }
                        String string = super.buildDetailString(variable);
                        return string;
                    }
                    finally {
                        currentLevel = (Integer)detailsLevel.get();
                        detailsLevel.set(currentLevel - 1);
                    }
                }
            };
        }
        if ("string".equals(type)) {
            return new StringScriptType("string");
        }
        return new ComplexScriptType(type){

            public String formatValue(IScriptValue value) {
                StringBuffer sb = new StringBuffer();
                sb.append(value.getRawValue());
                String id = value.getInstanceId();
                if (id != null) {
                    sb.append(" (id = " + id + ")");
                }
                return sb.toString();
            }

            public String formatDetails(IScriptValue value) {
                StringBuffer sb;
                block13: {
                    sb = new StringBuffer();
                    Integer currentLevel = (Integer)detailsLevel.get();
                    detailsLevel.set(currentLevel + 1);
                    try {
                        try {
                            IVariable[] variables = value.getVariables();
                            if (variables.length > 0) {
                                sb.append("{");
                                int i = 0;
                                while (i < variables.length) {
                                    sb.append(variables[i].getName());
                                    sb.append(":");
                                    if (variables[i].getValue() instanceof IScriptValue) {
                                        if (currentLevel < 2) {
                                            IScriptValue sv = (IScriptValue)variables[i].getValue();
                                            sb.append(sv.getType().formatDetails(sv));
                                        } else {
                                            sb.append("{...}");
                                        }
                                    } else {
                                        sb.append(variables[i].getValue().getValueString());
                                    }
                                    sb.append(",");
                                    ++i;
                                }
                                sb.setLength(sb.length() - 1);
                                sb.append("}");
                            } else {
                                sb.append(value.getRawValue());
                                String id = value.getInstanceId();
                                if (id != null) {
                                    sb.append(" (id = " + id + ")");
                                }
                            }
                        }
                        catch (DebugException ex) {
                            DLTKDebugPlugin.logWarning((String)"error creating variable details", (Throwable)ex);
                            currentLevel = (Integer)detailsLevel.get();
                            detailsLevel.set(currentLevel - 1);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        currentLevel = (Integer)detailsLevel.get();
                        detailsLevel.set(currentLevel - 1);
                        throw throwable;
                    }
                    currentLevel = (Integer)detailsLevel.get();
                    detailsLevel.set(currentLevel - 1);
                }
                return sb.toString();
            }
        };
    }
}

