/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RUnionType
extends RType
implements IRUnionType {
    final Set<IRType> targets = new LinkedHashSet<IRType>();

    public RUnionType(Collection<IRType> targets) {
        assert (!targets.contains(null));
        this.targets.addAll(targets);
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        for (IRType type : this.targets) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append(type.getName());
        }
        return sb.toString();
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        for (IRType target : this.targets) {
            if (!target.isAssignableFrom(type).ok()) continue;
            return TypeCompatibility.TRUE;
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public Set<IRType> getTargets() {
        return Collections.unmodifiableSet(this.targets);
    }

    public int hashCode() {
        return this.targets.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RUnionType) {
            RUnionType other = (RUnionType)obj;
            return this.targets.equals(other.targets);
        }
        return false;
    }
}

