/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRProperty;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicates;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.utils.CompoundIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTypeMemberQuery
implements Iterable<IRMember> {
    final List<QueueItem> types = new ArrayList<QueueItem>();
    static final int ALL = 0;
    static final int SUPERTYPES = 1;

    public RTypeMemberQuery() {
    }

    public RTypeMemberQuery(IRTypeDeclaration type) {
        this.add(type);
    }

    public RTypeMemberQuery(IRTypeDeclaration type, MemberPredicate predicate) {
        this.add(type, predicate);
    }

    public void add(IRTypeDeclaration type) {
        this.add(type, MemberPredicates.ALWAYS_TRUE);
    }

    public void add(IRTypeDeclaration type, MemberPredicate predicate) {
        Assert.isNotNull((Object)type);
        this.types.add(new QueueItem(type, predicate));
    }

    protected boolean isValid(IRTypeDeclaration type) {
        return true;
    }

    @Override
    public Iterator<IRMember> iterator() {
        return new MemberIterator(0);
    }

    public Iterable<IRMember> ignoreDuplicates() {
        return this.ignoreDuplicates(null);
    }

    public Iterable<IRMember> ignoreDuplicates(final Collection<String> ignoreMembers) {
        return new Iterable<IRMember>(){

            @Override
            public Iterator<IRMember> iterator() {
                return new IgnoreDuplicateMemberIterator(ignoreMembers);
            }
        };
    }

    public IRMember findMember(String memberName) {
        for (IRMember member : this) {
            if (!memberName.equals(member.getName())) continue;
            return member;
        }
        return null;
    }

    protected <T extends IRMember> T findMember(String memberName, Class<T> memberType) {
        for (IRMember member : this) {
            if (!memberType.isInstance(member) || !memberName.equals(member.getName())) continue;
            return (T)member;
        }
        return null;
    }

    public IRMethod findMethod(String methodName) {
        return this.findMember(methodName, IRMethod.class);
    }

    public IRProperty findProperty(String propertyName) {
        return this.findMember(propertyName, IRProperty.class);
    }

    public boolean contains(IRTypeDeclaration type) {
        for (QueueItem item : this.types) {
            if (type != item.type) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.types;
    }

    public IRMethod findSuperMethod(String methodName) {
        MemberIterator i = new MemberIterator(1);
        while (i.hasNext()) {
            IRMember member = (IRMember)i.next();
            if (!(member instanceof IRMethod) || !methodName.equals(member.getName())) continue;
            return (IRMethod)member;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IgnoreDuplicateMemberIterator
    extends MemberIterator {
        private final Set<Object> processed;
        private final Collection<String> ignored;
        private List<Object> abstractMethods;

        public IgnoreDuplicateMemberIterator(Collection<String> ignoreMembers) {
            super(0);
            this.processed = new HashSet<Object>();
            this.abstractMethods = new ArrayList<Object>();
            this.ignored = ignoreMembers != null ? ignoreMembers : Collections.emptySet();
        }

        @Override
        protected boolean isValid(IRMember member) {
            if (super.isValid(member) && !this.ignored.contains(member.getName())) {
                Object key = MethodKey.createKey(member);
                if (member instanceof IRMethod && ((IRMethod)member).isAbstract()) {
                    if (!this.processed.contains(key)) {
                        this.abstractMethods.add(key);
                        this.abstractMethods.add(member);
                    }
                    return false;
                }
                return this.processed.add(key);
            }
            return false;
        }

        @Override
        protected boolean fetchNext() {
            boolean result = super.fetchNext();
            if (!result && !this.abstractMethods.isEmpty()) {
                ArrayList<IRMember> queue = new ArrayList<IRMember>();
                int i = 0;
                while (i < this.abstractMethods.size()) {
                    if (this.processed.add(this.abstractMethods.get(i))) {
                        queue.add((IRMember)this.abstractMethods.get(i + 1));
                    }
                    i += 2;
                }
                this.abstractMethods.clear();
                if (!queue.isEmpty()) {
                    this.current = queue.iterator();
                    return true;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemberIterator
    extends CompoundIterator<IRMember> {
        private final TypeIterator typeIterator;
        private final Set<IRTypeDeclaration> entrypoints = new HashSet<IRTypeDeclaration>();

        public MemberIterator(int mode) {
            for (QueueItem item : RTypeMemberQuery.this.types) {
                this.entrypoints.add(item.type);
            }
            this.typeIterator = new TypeIterator(mode);
            this.current = Collections.emptyList().iterator();
        }

        private Collection<IRMember> filter(Collection<IRMember> members) {
            ArrayList<IRMember> result = new ArrayList<IRMember>();
            for (IRMember member : members) {
                if (!this.isValid(member)) continue;
                result.add(member);
            }
            return result;
        }

        protected boolean isValid(IRMember member) {
            if (member.isStatic()) {
                IRTypeDeclaration owner = member.getDeclaringType();
                return owner != null && (owner.isInheritStaticMembers() || this.entrypoints.contains(owner));
            }
            return true;
        }

        protected boolean fetchNext() {
            while (this.typeIterator.hasNext()) {
                QueueItem item = (QueueItem)this.typeIterator.next();
                List<IRMember> members = item.type.getMembers();
                if (item.predicate == MemberPredicates.ALWAYS_TRUE) {
                    this.current = this.filter(members).iterator();
                } else {
                    ArrayList<IRMember> filtered = new ArrayList<IRMember>(members.size());
                    for (IRMember member : members) {
                        if (!item.predicate.evaluate(member) || !this.isValid(member)) continue;
                        filtered.add(member);
                    }
                    this.current = filtered.iterator();
                }
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    private static class MemberKey {
        final String name;
        final boolean isStatic;

        public MemberKey(IRMember member) {
            this.name = member.getName();
            this.isStatic = member.isStatic();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberKey) {
                MemberKey other = (MemberKey)obj;
                return this.name.equals(other.name) && this.isStatic == other.isStatic;
            }
            return false;
        }
    }

    private static class MethodKey {
        final String name;
        final boolean isStatic;
        final String signature;

        public MethodKey(IRMethod method) {
            this.name = method.getName();
            this.isStatic = method.isStatic();
            StringBuilder sb = new StringBuilder();
            for (IRParameter parameter : method.getParameters()) {
                IRType paramType = parameter.getType();
                if (paramType != null) {
                    sb.append(paramType.getName());
                }
                sb.append(',');
            }
            this.signature = sb.toString();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey other = (MethodKey)obj;
                return this.name.equals(other.name) && this.isStatic == other.isStatic && this.signature.equals(other.signature);
            }
            return false;
        }

        protected static Object createKey(IRMember member) {
            if (member instanceof IRMethod && member.getDeclaringType() != null && member.getDeclaringType().getKind() == TypeKind.JAVA) {
                return new MethodKey((IRMethod)member);
            }
            return new MemberKey(member);
        }
    }

    private static class QueueItem {
        final IRTypeDeclaration type;
        final MemberPredicate predicate;

        public QueueItem(IRTypeDeclaration type, MemberPredicate predicate) {
            this.type = type;
            this.predicate = predicate;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueueItem) {
                QueueItem other = (QueueItem)obj;
                return this.type.equals(other.type) && this.predicate.equals(other.predicate);
            }
            return false;
        }

        public String toString() {
            return this.predicate + ":" + this.type.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeIterator
    extends CompoundIterator<QueueItem> {
        private final Set<QueueItem> visited = new HashSet<QueueItem>();
        private final List<QueueItem> queue = new ArrayList<QueueItem>();

        public TypeIterator(int mode) {
            if (mode == 0) {
                this.queue.addAll(RTypeMemberQuery.this.types);
            } else {
                assert (mode == 1);
                for (QueueItem qi : RTypeMemberQuery.this.types) {
                    IRTypeDeclaration type = qi.type;
                    IRTypeDeclaration superType = type.getSuperType();
                    if (superType != null) {
                        this.queue.add(new QueueItem(superType, qi.predicate));
                    }
                    for (IRTypeDeclaration trait : type.getTraits()) {
                        this.queue.add(new QueueItem(trait, qi.predicate));
                    }
                }
            }
            this.current = this.queue.iterator();
        }

        private boolean canVisit(QueueItem item) {
            return this.visited.add(item);
        }

        protected boolean fetchNext() {
            if (!this.queue.isEmpty()) {
                QueueItem[] copy = this.queue.toArray(new QueueItem[this.queue.size()]);
                this.queue.clear();
                QueueItem[] queueItemArray = copy;
                int n = copy.length;
                int n2 = 0;
                while (n2 < n) {
                    QueueItem superItem;
                    QueueItem item = queueItemArray[n2];
                    IRTypeDeclaration type = item.type;
                    IRTypeDeclaration superType = type.getSuperType();
                    if (superType != null && this.canVisit(superItem = new QueueItem(superType, item.predicate)) && RTypeMemberQuery.this.isValid(superType)) {
                        this.queue.add(superItem);
                    }
                    for (IRTypeDeclaration trait : type.getTraits()) {
                        QueueItem traitItem = new QueueItem(trait, item.predicate);
                        if (!this.canVisit(traitItem) || !RTypeMemberQuery.this.isValid(trait)) continue;
                        this.queue.add(traitItem);
                    }
                    ++n2;
                }
                this.current = this.queue.iterator();
                return this.current.hasNext();
            }
            return false;
        }
    }
}

