/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.javascript.typeinfo.IRConstructor;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRProperty;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTypeDeclaration
implements IRTypeDeclaration {
    @NonNull
    protected final ITypeSystem typeSystem;
    @NonNull
    protected final Type type;
    private RTypeDeclaration superType;
    private List<RTypeDeclaration> traits;
    private List<IRMember> members;
    private List<IRConstructor> constructors;
    private IRConstructor staticConstructor;

    public RTypeDeclaration(ITypeSystem typeSystem, Type type) {
        this.typeSystem = typeSystem;
        this.type = type;
    }

    protected ITypeSystem getEffectiveTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public Set<IProblemCategory> getSuppressedWarnings() {
        return Collections.emptySet();
    }

    @Override
    public boolean isSuppressed(IProblemIdentifier problemIdentifier) {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return this.type.isDeprecated();
    }

    @Override
    public ITypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public Type getSource() {
        return this.type;
    }

    @Override
    public IRTypeDeclaration getSuperType() {
        return this.superType;
    }

    @Override
    public List<IRTypeDeclaration> getTraits() {
        return this.traits;
    }

    @Override
    public List<IRMember> getMembers() {
        return this.members;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RTypeDeclaration other = (RTypeDeclaration)obj;
        return this.type.equals(other.type);
    }

    public String toString() {
        return this.getName();
    }

    public void setMembers(List<IRMember> members) {
        this.members = members;
    }

    public void setSuperType(RTypeDeclaration superType) {
        this.superType = superType;
    }

    public void setTraits(List<RTypeDeclaration> traits) {
        this.traits = traits;
    }

    @Override
    public TypeKind getKind() {
        return this.type.getKind();
    }

    @Override
    public boolean isInheritStaticMembers() {
        return this.type.isInheritStaticMembers();
    }

    @Override
    public Object getReadOnlyStatus(IRProperty property) {
        return this.type.getReadOnlyStatus(property.getSource());
    }

    @Override
    public boolean isGeneric() {
        return this.type instanceof GenericType;
    }

    @Override
    public boolean isParameterized() {
        return false;
    }

    @Override
    public List<IRType> getActualTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public List<IRConstructor> getConstructors() {
        return this.constructors;
    }

    public void setConstructors(List<IRConstructor> constructors) {
        this.constructors = constructors;
    }

    @Override
    public IRConstructor getStaticConstructor() {
        return this.staticConstructor;
    }

    public void setStaticConstructor(IRConstructor staticConstructor) {
        this.staticConstructor = staticConstructor;
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRTypeDeclaration declaration) {
        TypeCompatibility result = RTypeDeclaration.isAssignableFrom(this, (RTypeDeclaration)declaration, new HashSet<RTypeDeclaration>());
        return result != null ? result : TypeCompatibility.FALSE;
    }

    protected boolean _equals(RTypeDeclaration other) {
        return this.equals(other) || this.type.equals(other.type) || (this.type.getKind() == TypeKind.UNKNOWN || other.type.getKind() == TypeKind.UNKNOWN) && this.type.getName().equals(other.type.getName());
    }

    private static TypeCompatibility isAssignableFrom(RTypeDeclaration self, RTypeDeclaration current, Set<RTypeDeclaration> visited) {
        if (visited.add(current)) {
            TypeCompatibility result;
            if (self._equals(current)) {
                return TypeCompatibility.TRUE;
            }
            RTypeDeclaration superType = current.superType;
            if (superType != null && (result = RTypeDeclaration.isAssignableFrom(self, superType, visited)) != null) {
                return result;
            }
            for (RTypeDeclaration trait : current.traits) {
                TypeCompatibility result2 = RTypeDeclaration.isAssignableFrom(self, trait, visited);
                if (result2 == null) continue;
                return result2;
            }
        }
        return null;
    }

    @Override
    public IRMethod findMethod(String name, boolean isStatic) {
        for (IRMember member : this.members) {
            if (!(member instanceof IRMethod) || !name.equals(member.getName()) || isStatic != member.isStatic()) continue;
            return (IRMethod)member;
        }
        return null;
    }
}

