/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSNode;

public class ConditionalOperator
extends Expression {
    private Expression condition;
    private Expression trueValue;
    private Expression falseValue;
    private int questionPos = -1;
    private int colonPos = -1;

    public ConditionalOperator(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.condition != null) {
                this.condition.traverse(visitor);
            }
            if (this.trueValue != null) {
                this.trueValue.traverse(visitor);
            }
            if (this.falseValue != null) {
                this.falseValue.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Expression getTrueValue() {
        return this.trueValue;
    }

    public void setTrueValue(Expression value) {
        this.trueValue = value;
    }

    public Expression getFalseValue() {
        return this.falseValue;
    }

    public void setFalseValue(Expression value) {
        this.falseValue = value;
    }

    public int getQuestionPosition() {
        return this.questionPos;
    }

    public void setQuestionPosition(int questionPos) {
        this.questionPos = questionPos;
    }

    public int getColonPosition() {
        return this.colonPos;
    }

    public void setColonPosition(int colonPos) {
        this.colonPos = colonPos;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.questionPos > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.colonPos > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCondition().toSourceString(indentationString));
        buffer.append(" ? ");
        buffer.append(this.getTrueValue().toSourceString(indentationString));
        buffer.append(" : ");
        buffer.append(this.getFalseValue().toSourceString(indentationString));
        return buffer.toString();
    }
}

