/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.quickfix.TextFileEditResolution;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CreateLocalVariableQuickFix
extends TextFileEditResolution {
    public CreateLocalVariableQuickFix(IFile scriptFile, int problemStartIdx) {
        super(scriptFile, problemStartIdx);
    }

    public String getLabel() {
        return "Create local variable";
    }

    public Image getImage() {
        return DLTKPluginImages.getImage((AbstractUIPlugin)JavaScriptUI.getDefault(), (String)"icons/obj16/localvariable_obj.gif");
    }

    public String getDescription() {
        Identifier identifier = CreateLocalVariableQuickFix.getIdentifier(this.getScriptFile(), this.getProblemStartIdx());
        if (identifier != null) {
            JSNode parent = identifier.getParent();
            while (parent instanceof JSNode) {
                if (parent instanceof FunctionStatement) {
                    Statement statement = (Statement)((FunctionStatement)parent).getBody().getStatements().get(0);
                    ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.getScriptFile());
                    try {
                        String functionString = sourceModule.getBuffer().getText(parent.sourceStart(), statement.sourceStart() - parent.sourceStart());
                        StringBuilder sb = new StringBuilder(functionString.length() + 50);
                        sb.append("<html><body>");
                        sb.append(functionString.replace("\n", "<br>"));
                        sb.append("<b>var ");
                        sb.append(identifier.getName());
                        sb.append(";</b></body></html>");
                        return sb.toString();
                    }
                    catch (ModelException modelException) {
                        break;
                    }
                }
                parent = parent.getParent();
            }
            return "<html><body>Create local variable<br><b>var </b>" + identifier.getName() + "<body></html>";
        }
        return "Failed to create a local variable";
    }

    protected MultiTextEdit getTextEdit(IFile file, int offset) {
        MultiTextEdit textEdit = new MultiTextEdit();
        Identifier found = CreateLocalVariableQuickFix.getIdentifier(file, offset);
        if (found != null) {
            String extraLine = "\n";
            JSNode parent = found.getParent();
            ASTNode node = null;
            while (parent instanceof JSNode) {
                if (parent instanceof FunctionStatement) {
                    node = (ASTNode)((FunctionStatement)parent).getBody().getStatements().get(0);
                    extraLine = "";
                    break;
                }
                if (parent instanceof BinaryOperation && ((BinaryOperation)parent).isAssignment() && ((BinaryOperation)parent).getLeftExpression() == found) {
                    textEdit.addChild((TextEdit)new InsertEdit(found.sourceStart(), "var "));
                    node = null;
                    break;
                }
                if ((parent = parent.getParent()) instanceof Script) continue;
                node = parent;
            }
            if (node != null) {
                Comment documentation = ((JSNode)node).getDocumentation();
                String ident = "";
                int sourceStart = node.sourceStart();
                if (documentation != null) {
                    sourceStart = documentation.sourceStart();
                }
                try {
                    ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.getScriptFile());
                    String functionString = sourceModule.getBuffer().getText(parent.sourceStart(), sourceStart - parent.sourceStart());
                    int lastNewLine = functionString.lastIndexOf(10);
                    ident = lastNewLine != -1 ? functionString.substring(lastNewLine) : "\n";
                }
                catch (ModelException modelException) {}
                textEdit.addChild((TextEdit)new InsertEdit(sourceStart, "var " + found.getName() + ";" + extraLine + ident));
            }
        }
        return textEdit;
    }

    public static Identifier getIdentifier(IFile file, final int offset) {
        Script script = JavaScriptParserUtil.parse((ISourceModule)DLTKCore.createSourceModuleFrom((IFile)file));
        final Identifier[] found = new Identifier[1];
        ASTVisitor finder = new ASTVisitor(){

            public boolean visitGeneral(ASTNode node) throws Exception {
                ISourceRange range;
                if (found[0] != null) {
                    return false;
                }
                if (node instanceof Identifier && (range = ((Identifier)node).getRange()).getOffset() <= offset && range.getOffset() + range.getLength() >= offset) {
                    found[0] = (Identifier)node;
                    return false;
                }
                return true;
            }
        };
        try {
            script.traverse(finder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return found[0];
    }
}

