/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IProjectChange;
import org.eclipse.dltk.internal.core.builder.ExternalModuleCollector;
import org.eclipse.dltk.internal.core.builder.IncrementalProjectChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalBuildChange
extends IncrementalProjectChange
implements IBuildChange {
    private final IProjectChange[] projectChanges;
    private final List<IPath> oldExternalFolders;
    private int buildType = 0;
    private List<IPath> externalPaths = null;
    private Collection<IProjectFragment> externalFragments = null;
    private List<ISourceModule> externalModules = null;

    public IncrementalBuildChange(IResourceDelta delta, IProjectChange[] projectChanges, IProject project, IProgressMonitor monitor, List<IPath> oldExternalFolders) {
        super(delta, project, monitor);
        this.oldExternalFolders = oldExternalFolders;
        this.projectChanges = projectChanges;
    }

    @Override
    public int getBuildType() {
        return this.buildType;
    }

    @Override
    public void setBuildType(int buildType) {
        if (buildType != 1 && buildType != 0) {
            throw new IllegalArgumentException();
        }
        this.buildType = buildType;
    }

    @Override
    public boolean isDependencyBuild() {
        return false;
    }

    @Override
    public IProjectChange[] getRequiredProjectChanges() {
        return this.projectChanges;
    }

    @Override
    public boolean addChangedResource(IFile file) throws CoreException {
        return super.addChangedResource(file);
    }

    @Override
    public boolean addChangedResources(Collection<IFile> files) throws CoreException {
        boolean result = false;
        for (IFile file : files) {
            if (!this.addChangedResource(file)) continue;
            result = true;
        }
        return result;
    }

    private void loadExternalPaths() throws CoreException {
        if (this.externalPaths == null) {
            this.externalPaths = new ArrayList<IPath>();
            this.externalFragments = new ArrayList<IProjectFragment>();
            IProjectFragment[] allFragments = this.getScriptProject().getAllProjectFragments();
            int i = 0;
            while (i < allFragments.length) {
                IProjectFragment fragment = allFragments[i];
                if (fragment.isExternal()) {
                    IPath path = fragment.getPath();
                    this.externalPaths.add(path);
                    this.externalFragments.add(fragment);
                }
                ++i;
            }
        }
    }

    @Override
    public List<IPath> getExternalPaths(int options) throws CoreException {
        IncrementalBuildChange.validateFlags(options, 16);
        if (options == 16) {
            return this.oldExternalFolders;
        }
        this.loadExternalPaths();
        return Collections.unmodifiableList(this.externalPaths);
    }

    @Override
    public List<ISourceModule> getExternalModules(int options) throws CoreException {
        IncrementalBuildChange.validateFlags(options, 0);
        if (this.externalModules == null) {
            this.loadExternalPaths();
            ExternalModuleCollector moduleCollector = new ExternalModuleCollector(this.monitor);
            for (IProjectFragment fragment : this.externalFragments) {
                if (this.oldExternalFolders.contains(fragment.getPath())) continue;
                fragment.accept(moduleCollector);
            }
            this.externalModules = IncrementalBuildChange.unmodifiableList(moduleCollector.elements);
        }
        return this.externalModules;
    }
}

