/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.testing.model.TestContainerElement;
import org.eclipse.dltk.internal.testing.model.TestRoot;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestElementContainer;
import org.eclipse.dltk.testing.model.ITestRunSession;

public abstract class TestElement
implements ITestElement {
    private final TestContainerElement fParent;
    private final String fId;
    private String fTestName;
    private Status fStatus;
    private String fTrace;
    private String fExpected;
    private String fActual;
    double fTime = Double.NaN;

    public TestElement(TestContainerElement parent, String id, String testName) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)testName);
        this.fParent = parent;
        this.fId = id;
        this.fTestName = testName;
        this.fStatus = Status.NOT_RUN;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public ITestElement.ProgressState getProgressState() {
        return this.getStatus().convertToProgressState();
    }

    public ITestElement.Result getTestResult(boolean includeChildren) {
        return this.getStatus().convertToResult();
    }

    public ITestRunSession getTestRunSession() {
        return this.getRoot().getTestRunSession();
    }

    public ITestElementContainer getParentContainer() {
        if (this.fParent instanceof TestRoot) {
            return this.getTestRunSession();
        }
        return this.fParent;
    }

    public ITestElement.FailureTrace getFailureTrace() {
        ITestElement.Result testResult = this.getTestResult(false);
        if (testResult == ITestElement.Result.ERROR || testResult == ITestElement.Result.FAILURE) {
            return new ITestElement.FailureTrace(this.fTrace, this.fExpected, this.fActual);
        }
        return null;
    }

    public TestContainerElement getParent() {
        return this.fParent;
    }

    public String getId() {
        return this.fId;
    }

    public String getTestName() {
        return this.fTestName;
    }

    public void setStatus(Status status) {
        if (status == Status.RUNNING) {
            this.fTime = (double)(-System.currentTimeMillis()) / 1000.0;
        } else if (status.convertToProgressState() == ITestElement.ProgressState.COMPLETED && this.fTime < 0.0) {
            double endTime = (double)System.currentTimeMillis() / 1000.0;
            this.fTime = endTime + this.fTime;
        }
        this.fStatus = status;
        TestContainerElement parent = this.getParent();
        if (parent != null) {
            parent.childChangedStatus(this, status);
        }
    }

    public void setStatus(Status status, String trace, String expected, String actual) {
        this.fTrace = trace;
        this.fExpected = expected;
        this.fActual = actual;
        this.setStatus(status);
    }

    public void setElapsedTimeInSeconds(double time) {
        this.fTime = time;
    }

    public double getElapsedTimeInSeconds() {
        if (Double.isNaN(this.fTime) || this.fTime < 0.0) {
            return Double.NaN;
        }
        return this.fTime;
    }

    public Status getStatus() {
        return this.fStatus;
    }

    public String getTrace() {
        return this.fTrace;
    }

    public String getExpected() {
        return this.fExpected;
    }

    public String getActual() {
        return this.fActual;
    }

    public boolean isComparisonFailure() {
        return this.fExpected != null && this.fActual != null;
    }

    public TestRoot getRoot() {
        return this.getParent().getRoot();
    }

    public String toString() {
        return this.getProgressState() + " - " + this.getTestResult(true);
    }

    protected void setTestName(String value) {
        this.fTestName = value;
    }

    public static final class Status {
        public static final Status RUNNING_ERROR = new Status("RUNNING_ERROR", 5);
        public static final Status RUNNING_FAILURE = new Status("RUNNING_FAILURE", 6);
        public static final Status RUNNING = new Status("RUNNING", 3);
        public static final Status ERROR = new Status("ERROR", 1);
        public static final Status FAILURE = new Status("FAILURE", 2);
        public static final Status FAILURE_BLOCKED = new Status("BLOCKED", 2, 2);
        public static final Status FAILURE_SKIPPED = new Status("SKIPPED", 2, 1);
        public static final Status FAILURE_UNKNOWN = new Status("UNKNOWN", 2, 3);
        public static final Status FAILURE_ABORTED = new Status("ABORTED", 2, 0);
        public static final Status OK = new Status("OK", 0);
        public static final Status NOT_RUN = new Status("NOT_RUN", 4);
        private static final Status[] OLD_CODE = new Status[]{OK, ERROR, FAILURE};
        private String fName;
        private final int fOldCode;
        private int failedCode;

        private Status(String name, int oldCode) {
            this.fName = name;
            this.fOldCode = oldCode;
            this.failedCode = -2;
        }

        private Status(String name, int oldCode, int failedCode) {
            this.fName = name;
            this.fOldCode = oldCode;
            this.failedCode = failedCode;
        }

        public int getOldCode() {
            return this.fOldCode;
        }

        public String toString() {
            return this.fName;
        }

        public boolean isOK() {
            return this == OK || this == RUNNING || this == NOT_RUN;
        }

        public boolean isFailure() {
            return this.fOldCode == Status.FAILURE.fOldCode || this == RUNNING_FAILURE;
        }

        public int getFailedCode() {
            return this.failedCode;
        }

        public boolean isError() {
            return this == ERROR || this == RUNNING_ERROR;
        }

        public boolean isErrorOrFailure() {
            return this.isError() || this.isFailure();
        }

        public boolean isNotRun() {
            return this == NOT_RUN;
        }

        public boolean isRunning() {
            return this == RUNNING || this == RUNNING_FAILURE || this == RUNNING_ERROR;
        }

        public boolean isDone() {
            return this == OK || this == FAILURE || this == ERROR;
        }

        public static Status combineStatus(Status one, Status two) {
            Status progress = Status.combineProgress(one, two);
            Status error = Status.combineError(one, two);
            return Status.combineProgressAndErrorStatus(progress, error);
        }

        private static Status combineProgress(Status one, Status two) {
            if (one.isNotRun() && two.isNotRun()) {
                return NOT_RUN;
            }
            if (one.isDone() && two.isDone()) {
                return OK;
            }
            if (!one.isRunning() && !two.isRunning()) {
                return OK;
            }
            return RUNNING;
        }

        private static Status combineError(Status one, Status two) {
            if (one.isError() || two.isError()) {
                return ERROR;
            }
            if (one.isFailure() || two.isFailure()) {
                return FAILURE;
            }
            return OK;
        }

        private static Status combineProgressAndErrorStatus(Status progress, Status error) {
            if (progress.isDone()) {
                if (error.isError()) {
                    return ERROR;
                }
                if (error.isFailure()) {
                    return FAILURE;
                }
                return OK;
            }
            if (progress.isNotRun()) {
                return NOT_RUN;
            }
            if (error.isError()) {
                return RUNNING_ERROR;
            }
            if (error.isFailure()) {
                return RUNNING_FAILURE;
            }
            return RUNNING;
        }

        public static Status convert(int oldStatus, int failedCode) {
            if (oldStatus < 3) {
                if (oldStatus == 2) {
                    switch (failedCode) {
                        case 0: {
                            return FAILURE_ABORTED;
                        }
                        case 2: {
                            return FAILURE_BLOCKED;
                        }
                        case 1: {
                            return FAILURE_SKIPPED;
                        }
                        case 3: {
                            return FAILURE_UNKNOWN;
                        }
                    }
                    return FAILURE;
                }
                return OLD_CODE[oldStatus];
            }
            return null;
        }

        public ITestElement.Result convertToResult() {
            if (this.isNotRun()) {
                return ITestElement.Result.UNDEFINED;
            }
            if (this.isError()) {
                return ITestElement.Result.ERROR;
            }
            if (this.isFailure()) {
                return ITestElement.Result.FAILURE;
            }
            if (this.isRunning()) {
                return ITestElement.Result.UNDEFINED;
            }
            return ITestElement.Result.OK;
        }

        public ITestElement.ProgressState convertToProgressState() {
            if (this.isRunning()) {
                return ITestElement.ProgressState.RUNNING;
            }
            if (this.isDone()) {
                return ITestElement.ProgressState.COMPLETED;
            }
            return ITestElement.ProgressState.NOT_STARTED;
        }
    }
}

