/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.annotations.ConfigurationElement;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.typeinfo.DefaultMetaType;
import org.eclipse.dltk.javascript.typeinfo.IElementConverter;
import org.eclipse.dltk.javascript.typeinfo.IElementResolver;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRTypeFactory;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceExtensionFactory;
import org.eclipse.dltk.javascript.typeinfo.ITypeInferenceHandlerFactory;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeProvider;
import org.eclipse.dltk.javascript.typeinfo.MetaType;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.NamedElement;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelResourceSet;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.dltk.utils.SimpleExtensionManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoManager {
    public static final String EXT_POINT = "org.eclipse.dltk.javascript.core.typeinfo";
    private static final String MODEL_ELEMENT = "model";
    private static final String RESOURCE_ATTR = "resource";
    private static final String URI_ATTR = "uri";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final SimpleExtensionManager<IModelBuilder> modelBuilderManager = TypeInfoManager.createManager(IModelBuilder.class);
    private static final LazyExtensionManager<ITypeProvider> providerManager = new LazyExtensionManager<ITypeProvider>("org.eclipse.dltk.javascript.core.typeinfo"){

        protected boolean isValidElement(IConfigurationElement element) {
            return TypeInfoManager.PROVIDER_ELEMENT.equals(element.getName());
        }

        protected LazyExtensionManager.Descriptor<ITypeProvider> createDescriptor(IConfigurationElement element) {
            return new TypeProviderDescriptor(this, element);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TypeProviderDescriptor
        extends LazyExtensionManager.Descriptor<ITypeProvider> {
            public TypeProviderDescriptor(LazyExtensionManager<ITypeProvider> manager, IConfigurationElement configurationElement) {
                super(manager, configurationElement);
            }

            public ITypeProvider get() {
                return (ITypeProvider)this.create();
            }
        }
    };
    private static final SimpleExtensionManager<IElementResolver> resolverManager = TypeInfoManager.createManager(IElementResolver.class);
    private static final SimpleExtensionManager<IElementConverter> converterManager = TypeInfoManager.createManager(IElementConverter.class);
    private static final SimpleExtensionManager<IMemberEvaluator> evaluatorManager = TypeInfoManager.createManager(IMemberEvaluator.class);
    private static final SimpleExtensionManager<ITypeInferenceHandlerFactory> nodeHandlerManager = TypeInfoManager.createManager(ITypeInferenceHandlerFactory.class);
    private static final SimpleExtensionManager<IRTypeFactory> typeFactoryManager = TypeInfoManager.createManager(IRTypeFactory.class);
    private static final SimpleExtensionManager<MetaType> metaTypeManager = TypeInfoManager.createManager(MetaType.class);
    private static final Set<String> reportedMetaTypeIds = new HashSet<String>();

    private static String trim(String str) {
        if (str != null && (str = str.trim()).length() == 0) {
            str = null;
        }
        return str;
    }

    private static URI createURI(IConfigurationElement element, String resource) {
        return URI.createPlatformPluginURI((String)("/" + element.getContributor().getName() + "/" + resource), (boolean)true);
    }

    private static IConfigurationElement[] getConfigurationElements() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_POINT);
    }

    public static <E> SimpleExtensionManager<E> createManager(Class<E> elementType) {
        return new ExtManager<E>(elementType);
    }

    public static IModelBuilder[] getModelBuilders(ITypeInfoContext context) {
        IModelBuilder[] all = (IModelBuilder[])modelBuilderManager.getInstances();
        if (context == null) {
            return all;
        }
        HashMap<String, ModelBuilderRec> recs = new HashMap<String, ModelBuilderRec>();
        IModelBuilder[] iModelBuilderArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder builder = iModelBuilderArray[n2];
            int priority = builder.priorityFor(context);
            if (priority != -1) {
                String featureId = builder.getFeatureId();
                ModelBuilderRec rec = (ModelBuilderRec)recs.get(featureId);
                if (rec != null) {
                    if (priority > rec.priority) {
                        rec.priority = priority;
                        rec.builder = builder;
                    }
                } else {
                    rec = new ModelBuilderRec();
                    rec.builder = builder;
                    rec.priority = priority;
                    recs.put(featureId, rec);
                }
            }
            ++n2;
        }
        IModelBuilder[] result = new IModelBuilder[recs.size()];
        int index = 0;
        for (ModelBuilderRec rec : recs.values()) {
            result[index++] = rec.builder;
        }
        return result;
    }

    public static ITypeProvider[] createTypeProviders(ITypeInfoContext context) {
        LazyExtensionManager.Descriptor[] descriptors = providerManager.getDescriptors();
        ITypeProvider[] providers = new ITypeProvider[descriptors.length];
        int index = 0;
        LazyExtensionManager.Descriptor[] descriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            LazyExtensionManager.Descriptor descriptor = descriptorArray[n2];
            ITypeProvider provider = (ITypeProvider)descriptor.get();
            if (provider != null && provider.initialize(context)) {
                providers[index++] = provider;
            }
            ++n2;
        }
        if (index != providers.length) {
            ITypeProvider[] result = new ITypeProvider[index];
            System.arraycopy(providers, 0, result, 0, index);
            return result;
        }
        return providers;
    }

    public static IElementResolver[] getElementResolvers() {
        return (IElementResolver[])resolverManager.getInstances();
    }

    public static IElementConverter[] getElementConverters() {
        return (IElementConverter[])converterManager.getInstances();
    }

    public static IMemberEvaluator[] getMemberEvaluators() {
        return (IMemberEvaluator[])evaluatorManager.getInstances();
    }

    public static ITypeInferenceHandlerFactory[] getNodeHandlerFactories() {
        return (ITypeInferenceHandlerFactory[])nodeHandlerManager.getInstances();
    }

    public static <E> List<E> createExtensions(IAdaptable context, Class<E> extensionClass, Object arg) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        ITypeInferenceHandlerFactory[] iTypeInferenceHandlerFactoryArray = TypeInfoManager.getNodeHandlerFactories();
        int n = iTypeInferenceHandlerFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object extension;
            ITypeInferenceHandlerFactory factory = iTypeInferenceHandlerFactoryArray[n2];
            if (factory instanceof ITypeInferenceExtensionFactory && (extension = ((ITypeInferenceExtensionFactory)((Object)factory)).createExtension(context, extensionClass, arg)) != null && extensionClass.isInstance(extension)) {
                extensions.add(extension);
            }
            ++n2;
        }
        return extensions;
    }

    public static IRTypeFactory[] getRTypeFactories() {
        return (IRTypeFactory[])typeFactoryManager.getInstances();
    }

    public static TypeInfoModelResourceSet loadModelResources() {
        TypeInfoModelResourceSet resourceSet = new TypeInfoModelResourceSet();
        IConfigurationElement[] iConfigurationElementArray = TypeInfoManager.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (MODEL_ELEMENT.equals(element.getName())) {
                String resource = TypeInfoManager.trim(element.getAttribute(RESOURCE_ATTR));
                String uri = TypeInfoManager.trim(element.getAttribute(URI_ATTR));
                try {
                    if (uri != null) {
                        if (resource != null) {
                            resourceSet.getURIConverter().getURIMap().put(URI.createURI((String)uri), TypeInfoManager.createURI(element, resource));
                            resourceSet.getResources().add((Object)TypeInfoManager.newResource(URI.createURI((String)uri)));
                        }
                    } else if (resource != null) {
                        resourceSet.getResources().add((Object)TypeInfoManager.newResource(TypeInfoManager.createURI(element, resource)));
                    }
                }
                catch (IllegalArgumentException e) {
                    JavaScriptPlugin.error(e);
                }
            }
            ++n2;
        }
        for (Resource r : new ArrayList(resourceSet.getResources())) {
            if (r.isLoaded()) continue;
            try {
                r.load(null);
            }
            catch (IOException e) {
                JavaScriptPlugin.error("Error loading " + r.getURI(), e);
                if (r.isLoaded()) continue;
                r.getContents().clear();
            }
        }
        return resourceSet;
    }

    public static XMIResource newResource() {
        return new TypeInfoXMIResource();
    }

    public static XMIResource newResource(URI uri) {
        return new TypeInfoXMIResource(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaType getMetaType(String initialValue) {
        if (initialValue != null) {
            MetaType[] metaTypeArray = (MetaType[])metaTypeManager.getInstances();
            int n = metaTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MetaType metaType = metaTypeArray[n2];
                if (initialValue.equals(metaType.getId())) {
                    return metaType;
                }
                ++n2;
            }
            Set<String> set = reportedMetaTypeIds;
            synchronized (set) {
                if (reportedMetaTypeIds.size() < 16 && reportedMetaTypeIds.add(initialValue)) {
                    JavaScriptPlugin.error(NLS.bind((String)"MetaType {0} not found", (Object)initialValue));
                }
            }
        }
        return DefaultMetaType.DEFAULT;
    }

    public static List<MetaType> getMetaTypes() {
        return Collections.unmodifiableList(Arrays.asList((MetaType[])metaTypeManager.getInstances()));
    }

    @Nullable
    public static IModelElement convertElement(ISourceModule module, Element element) {
        IElementConverter[] iElementConverterArray = TypeInfoManager.getElementConverters();
        int n = iElementConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementConverter converter = iElementConverterArray[n2];
            IModelElement converted = converter.convert(module, element);
            if (converted != null) {
                return converted;
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtManager<E>
    extends SimpleExtensionManager<E> {
        private final String elementName;

        ExtManager(Class<E> elementType) {
            super(elementType, TypeInfoManager.EXT_POINT);
            this.elementName = elementType.getAnnotation(ConfigurationElement.class).value();
        }

        protected E createInstance(IConfigurationElement element) {
            if (this.elementName.equals(element.getName())) {
                return (E)super.createInstance(element);
            }
            return null;
        }
    }

    static class ModelBuilderRec {
        IModelBuilder builder;
        int priority;

        ModelBuilderRec() {
        }
    }

    public static class TypeInfoXMIResource
    extends XMIResourceImpl {
        private static final String ROOT = "@ROOT";

        public TypeInfoXMIResource() {
        }

        public TypeInfoXMIResource(URI uri) {
            super(uri);
        }

        public EObject getEObject(String uriFragment) {
            if (uriFragment.startsWith(ROOT) && uriFragment.length() > ROOT.length() && uriFragment.charAt(ROOT.length()) == '/') {
                StringTokenizer tokenizer = new StringTokenizer(uriFragment.substring(ROOT.length() + 1), "/");
                TypeInfoXMIResource obj = this;
                block0: while (tokenizer.hasMoreTokens()) {
                    String name = URI.decode((String)tokenizer.nextToken());
                    EList children = obj instanceof Resource ? ((Resource)obj).getContents() : ((EObject)obj).eContents();
                    for (EObject child : children) {
                        if (!(child instanceof NamedElement) || !name.equals(((NamedElement)child).getName())) continue;
                        obj = child;
                        continue block0;
                    }
                    return super.getEObject(uriFragment);
                }
                return (EObject)obj;
            }
            return super.getEObject(uriFragment);
        }

        public String getURIFragment(EObject eObject) {
            if (eObject.eContainer() != null) {
                ArrayList<String> path;
                block3: {
                    path = new ArrayList<String>();
                    EObject obj = eObject;
                    do {
                        path.add(((NamedElement)obj).getName());
                        obj = obj.eContainer();
                        if (obj == null) break block3;
                    } while (obj instanceof NamedElement);
                    return super.getURIFragment(eObject);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(ROOT);
                int i = path.size() - 1;
                while (i >= 0) {
                    sb.append('/');
                    sb.append(URI.encodeSegment((String)((String)path.get(i)), (boolean)false));
                    --i;
                }
                return sb.toString();
            }
            return super.getURIFragment(eObject);
        }
    }
}

