/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;

public abstract class ReferenceSource
implements IAdaptable {
    public static final ReferenceSource UNKNOWN = new Unknown();

    public static ReferenceSource create(IModelElement modelElement) {
        return modelElement != null ? new ModelElementSource(modelElement) : new Dummy();
    }

    public abstract IModelElement getModelElement();

    public abstract ISourceModule getSourceModule();

    public Object getAdapter(Class adapter) {
        if (adapter == ReferenceSource.class) {
            return this;
        }
        return null;
    }

    static class Dummy
    extends Unknown {
        Dummy() {
        }

        public String toString() {
            return "Dummy";
        }
    }

    private static class ModelElementSource
    extends ReferenceSource {
        @NonNull
        private final IModelElement modelElement;

        public ModelElementSource(IModelElement modelElement) {
            this.modelElement = modelElement;
        }

        public IModelElement getModelElement() {
            return this.modelElement;
        }

        public ISourceModule getSourceModule() {
            return this.modelElement instanceof ISourceModule ? (ISourceModule)this.modelElement : null;
        }

        public String toString() {
            return this.modelElement.getElementName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModelElementSource) {
                return this.modelElement.equals(((ModelElementSource)obj).modelElement);
            }
            return false;
        }
    }

    static class Unknown
    extends ReferenceSource {
        Unknown() {
        }

        public IModelElement getModelElement() {
            return null;
        }

        public ISourceModule getSourceModule() {
            return null;
        }

        public String toString() {
            return "UNKNOWN";
        }
    }
}

