/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposalCollector;
import org.eclipse.dltk.javascript.scriptdoc.JavaHeuristicScanner;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalExtension2;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptTypeCompletionProposalComputer
extends ScriptCompletionProposalComputer {
    protected TemplateCompletionProcessor createTemplateProposalComputer(ScriptContentAssistInvocationContext context) {
        return null;
    }

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        int paren;
        int contextPosition = context.getInvocationOffset();
        IDocument document = context.getDocument();
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        while ((paren = scanner.findOpeningPeer(pos, bound, '(', ')')) != -1) {
            int token = scanner.previousToken(paren - 1, bound);
            if (token == 2000) {
                return paren;
            }
            pos = paren - 1;
        }
        return contextPosition;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (DLTKCore.DEBUG) {
            System.out.println("Offset: " + context.getInvocationOffset());
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".computeContextInformation()");
        }
        if (context instanceof ScriptContentAssistInvocationContext) {
            int completionOffset = this.guessContextInformationPosition(context);
            List proposals = this.computeScriptCompletionProposals(completionOffset, (ScriptContentAssistInvocationContext)context, monitor);
            if (DLTKCore.DEBUG) {
                System.out.println("!!! Proposals: " + proposals.size());
            }
            ArrayList<IContextInformation> list = new ArrayList<IContextInformation>();
            for (ICompletionProposal proposal : proposals) {
                IScriptCompletionProposalExtension2 e2;
                IContextInformation contextInformation = proposal.getContextInformation();
                if (contextInformation == null || proposal instanceof IScriptCompletionProposalExtension2 && (e2 = (IScriptCompletionProposalExtension2)proposal).getReplacementLength() != e2.getName().length()) continue;
                if (DLTKCore.DEBUG) {
                    System.out.println("Proposal: " + proposal + ", info: " + contextInformation.getInformationDisplayString());
                }
                list.add(contextInformation);
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected ScriptCompletionProposalCollector createCollector(ScriptContentAssistInvocationContext context) {
        return new JavaScriptCompletionProposalCollector(context.getSourceModule());
    }
}

