/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Documentable;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.JSScope;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;

public class Identifier
extends Expression
implements Documentable {
    private String name;
    private Comment documentation;

    public Identifier(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            visitor.endvisit((ASTNode)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDocumentation(Comment documentation) {
        this.documentation = documentation;
    }

    public Comment getDocumentation() {
        return this.documentation;
    }

    public String toSourceString(String indentationString) {
        return this.name;
    }

    public boolean isSymbolReference() {
        JSNode parent = this.getParent();
        if (parent instanceof PropertyInitializer) {
            return ((PropertyInitializer)parent).getName() != this;
        }
        if (parent instanceof PropertyExpression) {
            return ((PropertyExpression)parent).getProperty() != this;
        }
        return !(parent instanceof XmlAttributeIdentifier);
    }

    public JSDeclaration findDeclaration() {
        if (this.isSymbolReference()) {
            JSNode parent = this.getParent();
            while (parent != null) {
                if (parent instanceof JSScope) {
                    for (JSDeclaration declaration : ((JSScope)((Object)parent)).getDeclarations()) {
                        Identifier id = declaration.getIdentifier();
                        if (id == null || !this.name.equals(id.getName())) continue;
                        return declaration;
                    }
                }
                parent = parent.getParent();
            }
        }
        return null;
    }
}

