/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class AbstractConfigurationBlockPropertyAndPreferencePage
extends PropertyAndPreferencePage {
    private AbstractOptionsBlock block;

    public AbstractConfigurationBlockPropertyAndPreferencePage() {
        this.setDescription();
        this.setPreferenceStore();
    }

    public final void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        this.block = this.createOptionsBlock(this.getNewStatusChangedListener(), this.getProject(), container);
        super.createControl(parent);
        String helpId = this.isProjectPreferencePage() ? this.getProjectHelpId() : this.getHelpId();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), helpId);
    }

    public final void dispose() {
        if (this.block != null) {
            this.block.dispose();
        }
        super.dispose();
    }

    public final void performApply() {
        if (this.block != null) {
            this.block.performApply();
        }
    }

    public final boolean performOk() {
        if (this.block != null && !this.block.performOk()) {
            return false;
        }
        return super.performOk();
    }

    public final void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }

    protected abstract AbstractOptionsBlock createOptionsBlock(IStatusChangeListener var1, IProject var2, IWorkbenchPreferenceContainer var3);

    protected abstract String getHelpId();

    protected abstract String getProjectHelpId();

    protected abstract void setDescription();

    protected abstract void setPreferenceStore();

    protected final Control createPreferenceContent(Composite composite) {
        return this.block.createContents(composite);
    }

    protected final void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.block != null) {
            this.block.useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    protected final boolean hasProjectSpecificOptions(IProject project) {
        return this.block.hasProjectSpecificOptions(project);
    }

    protected final void performDefaults() {
        super.performDefaults();
        if (this.block != null) {
            this.block.performDefaults();
        }
    }
}

