/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ScriptElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int STATIC = 8;
    public static final int CONSTRUCTOR = 512;
    public static final int OVERRIDES = 128;
    public static final int IMPLEMENTS = 256;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    private Point fSize;
    private int fFlags;
    private final ImageDescriptor fBaseImage;

    public ScriptElementImageDescriptor(ImageDescriptor baseImageDescriptor, int flags, Point size) {
        this.fBaseImage = baseImageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !ScriptElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        ScriptElementImageDescriptor other = (ScriptElementImageDescriptor)((Object)object);
        return other.fFlags == this.fFlags && this.fBaseImage.equals(other.fBaseImage) && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fSize.hashCode() | this.fFlags;
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            System.err.println("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        if (bg != null) {
            this.drawImage(bg, 0, 0);
        }
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private void drawBottomLeft() {
        ImageData data;
        Point size = this.getSize();
        int x = 0;
        if ((this.fFlags & 0x40) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_ERROR);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_WARNING);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }

    private void drawTopRight() {
        Point pos = new Point(this.getSize().x, 0);
        if ((this.fFlags & 1) != 0) {
            this.addTopRightImage(DLTKPluginImages.DESC_OVR_ABSTRACT, pos);
        }
        if ((this.fFlags & 0x200) != 0) {
            this.addTopRightImage(DLTKPluginImages.DESC_OVR_CONSTRUCTOR, pos);
        }
        if ((this.fFlags & 2) != 0) {
            this.addTopRightImage(DLTKPluginImages.DESC_OVR_FINAL, pos);
        }
        if ((this.fFlags & 8) != 0) {
            this.addTopRightImage(DLTKPluginImages.DESC_OVR_STATIC, pos);
        }
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        Point pos = new Point(size.x, size.y);
        int flags = this.fFlags;
        if ((flags & 0x80) != 0) {
            this.addBottomRightImage(DLTKPluginImages.DESC_OVR_OVERRIDES, pos);
        }
        if ((flags & 0x100) != 0) {
            this.addBottomRightImage(DLTKPluginImages.DESC_OVR_IMPLEMENTS, pos);
        }
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }
}

