/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.util.MethodOverrideTester;
import org.eclipse.dltk.internal.ui.IWorkingCopyProvider;
import org.eclipse.dltk.internal.ui.typehierarchy.CumulativeType;
import org.eclipse.dltk.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected TreeViewer fViewer;
    private ViewerFilter fWorkingSetFilter;
    private MethodOverrideTester fMethodOverrideTester;
    private ITypeHierarchyLifeCycleListener fTypeHierarchyLifeCycleListener;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fTypeHierarchy = lifecycle;
        this.fMemberFilter = null;
        this.fWorkingSetFilter = null;
        this.fMethodOverrideTester = null;
        this.fTypeHierarchyLifeCycleListener = new ITypeHierarchyLifeCycleListener(){

            public void typeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchyProvider, IType[] changedTypes) {
                if (changedTypes == null) {
                    TypeHierarchyContentProvider.this.fMethodOverrideTester = null;
                }
            }
        };
        lifecycle.addChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public final void setMemberFilter(IMember[] memberFilter) {
        this.fMemberFilter = memberFilter;
    }

    private boolean initializeMethodOverrideTester(IMethod filterMethod, IType typeToFindIn) {
        IType focusType;
        IType filterType = filterMethod.getDeclaringType();
        ITypeHierarchy hierarchy = this.fTypeHierarchy.getHierarchy();
        boolean filterOverrides = ScriptModelUtil.isSuperType((ITypeHierarchy)hierarchy, (IType)typeToFindIn, (IType)filterType);
        IType iType = focusType = filterOverrides ? filterType : typeToFindIn;
        if (this.fMethodOverrideTester == null || !this.fMethodOverrideTester.getFocusType().equals(focusType)) {
            this.fMethodOverrideTester = new MethodOverrideTester(focusType, hierarchy);
        }
        return filterOverrides;
    }

    private void addCompatibleMethods(IMethod filterMethod, IType typeToFindIn, Collection children) throws ModelException {
        boolean filterMethodOverrides = this.initializeMethodOverrideTester(filterMethod, typeToFindIn);
        IMethod[] methods = typeToFindIn.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod curr = methods[i];
            if (this.isCompatibleMethod(filterMethod, curr, filterMethodOverrides) && !children.contains(curr)) {
                children.add(curr);
            }
            ++i;
        }
    }

    private boolean hasCompatibleMethod(IMethod filterMethod, IType typeToFindIn) throws ModelException {
        boolean filterMethodOverrides = this.initializeMethodOverrideTester(filterMethod, typeToFindIn);
        IMethod[] methods = typeToFindIn.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (this.isCompatibleMethod(filterMethod, methods[i], filterMethodOverrides)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isCompatibleMethod(IMethod filterMethod, IMethod method, boolean filterOverrides) throws ModelException {
        if (filterOverrides) {
            return this.fMethodOverrideTester.isSubsignature(filterMethod, method);
        }
        return this.fMethodOverrideTester.isSubsignature(method, filterMethod);
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void setWorkingSetFilter(ViewerFilter filter) {
        this.fWorkingSetFilter = filter;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    @Override
    public boolean providesWorkingCopies() {
        return true;
    }

    public Object[] getElements(Object parent) {
        ArrayList<Object> types = new ArrayList<Object>();
        this.getRootTypes(types);
        int i = types.size() - 1;
        while (i >= 0) {
            IType curr = (IType)types.get(i);
            try {
                if (!this.isInTree(curr)) {
                    types.remove(i);
                }
            }
            catch (ModelException modelException) {}
            --i;
        }
        this.compactTypes(types);
        return types.toArray();
    }

    protected void compactTypes(Collection<Object> types) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<Object> i = types.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (!(item instanceof IType)) continue;
            IType type = (IType)item;
            String qName = type.getFullyQualifiedName(".");
            Object value = map.get(qName);
            if (value == null) {
                map.put(qName, type);
            } else if (value instanceof List) {
                ((List)value).add(type);
            } else {
                ArrayList<Object> list = new ArrayList<Object>(4);
                list.add(value);
                list.add(type);
                map.put(qName, list);
            }
            i.remove();
        }
        ArrayList qNames = new ArrayList(map.keySet());
        Collections.sort(qNames);
        for (String qName : qNames) {
            Object value = map.get(qName);
            if (value instanceof List) {
                List list = (List)value;
                types.add(new CumulativeType(qName, list.toArray(new IType[list.size()])));
                continue;
            }
            types.add(value);
        }
    }

    protected void getRootTypes(List res) {
        IType input;
        ITypeHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null && (input = hierarchy.getType()) != null) {
            res.add(input);
        }
    }

    protected abstract void getTypesInHierarchy(IType var1, List var2);

    protected abstract IType[] getParentType(IType var1);

    private boolean isInScope(IType type) {
        if (this.fWorkingSetFilter != null && !this.fWorkingSetFilter.select(null, null, (Object)type)) {
            return false;
        }
        IModelElement input = this.fTypeHierarchy.getInputElement();
        int inputType = input.getElementType();
        if (inputType == 7) {
            return true;
        }
        IModelElement parent = type.getAncestor(input.getElementType());
        return inputType == 3 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                HashSet<Object> children = new HashSet<Object>();
                if (this.fMemberFilter != null) {
                    this.addFilteredMemberChildren(type, children);
                }
                this.addTypeChildren(type, children);
                this.compactTypes(children);
                return children.toArray();
            }
            catch (ModelException modelException) {}
        } else if (element instanceof CumulativeType) {
            try {
                CumulativeType cType = (CumulativeType)element;
                IType[] types = cType.getTypes();
                HashSet<Object> children = new HashSet<Object>();
                int i = 0;
                while (i < types.length) {
                    if (this.fMemberFilter != null) {
                        this.addFilteredMemberChildren(types[i], children);
                    }
                    this.addTypeChildren(types[i], children);
                    ++i;
                }
                this.compactTypes(children);
                ArrayList<Object> result = new ArrayList<Object>(children.size());
                result.addAll(children);
                cType.insertTo(result, 0);
                return result.toArray();
            }
            catch (ModelException modelException) {}
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                return this.hasTypeChildren(type) || this.fMemberFilter != null && this.hasMemberFilterChildren(type);
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        return element instanceof CumulativeType;
    }

    private void addFilteredMemberChildren(IType parent, Collection children) throws ModelException {
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMember member = this.fMemberFilter[i];
            if (parent.equals(member.getDeclaringType())) {
                if (!children.contains(member)) {
                    children.add(member);
                }
            } else if (member instanceof IMethod) {
                this.addCompatibleMethods((IMethod)member, parent, children);
            }
            ++i;
        }
    }

    private void addTypeChildren(IType type, Collection children) throws ModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = (IType)types.get(i);
            if (this.isInTree(curr)) {
                children.add(curr);
            }
            ++i;
        }
    }

    protected final boolean isInTree(IType type) throws ModelException {
        if (this.isInScope(type)) {
            if (this.fMemberFilter != null) {
                return this.hasMemberFilterChildren(type) || this.hasTypeChildren(type);
            }
            return true;
        }
        return this.hasTypeChildren(type);
    }

    private boolean hasMemberFilterChildren(IType type) throws ModelException {
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMember member = this.fMemberFilter[i];
            if (type.equals(member.getDeclaringType())) {
                return true;
            }
            if (member instanceof IMethod && this.hasCompatibleMethod((IMethod)member, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeChildren(IType type) throws ModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = (IType)types.get(i);
            if (this.isInTree(curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer part, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(part instanceof TreeViewer));
        this.fViewer = (TreeViewer)part;
    }

    public void resetState() {
    }

    public void dispose() {
        this.fTypeHierarchy.removeChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public Object getParent(Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            if (member.getElementType() == 7) {
                IType[] parents = this.getParentType((IType)member);
                if (parents != null && parents.length == 1) {
                    return parents[0];
                }
                return null;
            }
            return member.getDeclaringType();
        }
        if (element instanceof CumulativeType.Part) {
            return ((CumulativeType.Part)element).getParent();
        }
        return null;
    }
}

