/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ScriptUtils;
import org.eclipse.dltk.internal.ui.text.CompositeReconcilingStrategy;
import org.eclipse.dltk.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.dltk.internal.ui.text.ScriptReconcilingStrategy;
import org.eclipse.dltk.internal.ui.text.spelling.ScriptSpellingReconcileStrategy;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.spelling.SpellCheckDelegate;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptCompositeReconcilingStrategy
extends CompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private ScriptReconcilingStrategy fScriptStrategy;

    public ScriptCompositeReconcilingStrategy(ITextEditor editor, String documentPartitioning, SpellCheckDelegate spellCheckDelegate) {
        IContentType contentType;
        IDLTKLanguageToolkit toolkit;
        this.fEditor = editor;
        this.fScriptStrategy = new ScriptReconcilingStrategy(editor);
        ArrayList<Object> strategies = new ArrayList<Object>();
        strategies.add(this.fScriptStrategy);
        if (spellCheckDelegate != null && (toolkit = ScriptUtils.getLanguageToolkit((Object)editor)) != null && (contentType = Platform.getContentTypeManager().getContentType(toolkit.getLanguageContentType())) != null) {
            strategies.add(new ScriptSpellingReconcileStrategy(editor, documentPartitioning, contentType, spellCheckDelegate));
        }
        this.setReconcilingStrategies(strategies.toArray(new IReconcilingStrategy[strategies.size()]));
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel m;
        if (this.fEditor == null) {
            return null;
        }
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            p = DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider();
        }
        if ((m = p.getAnnotationModel((Object)this.fEditor.getEditorInput())) instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)m;
        }
        return null;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(dirtyRegion, subRegion);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(partition);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(partition);
        }
    }

    public void initialReconcile() {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.initialReconcile();
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.initialReconcile();
        }
    }

    public void notifyListeners(boolean notify) {
        this.fScriptStrategy.notifyListeners(notify);
    }

    public void aboutToBeReconciled() {
        this.fScriptStrategy.aboutToBeReconciled();
    }
}

