/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.Checks;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NewNameQueries
implements INewNameQueries {
    private static final String INVALID_NAME_NO_MESSAGE = "";
    private final Wizard fWizard;
    private final Shell fShell;

    public NewNameQueries() {
        this.fShell = null;
        this.fWizard = null;
    }

    public NewNameQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public NewNameQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue((this.fWizard == null || this.fShell == null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    public INewNameQuery createNewSourceModuleNameQuery(ISourceModule cu, String initialSuggestedName) {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO:add removeScriptLikeExtensions code here...");
        }
        Object[] keys = new String[]{cu.getElementName()};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createSourceModuleNameValidator(cu), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewResourceNameQuery(IResource res, String initialSuggestedName) {
        Object[] keys = new String[]{res.getName()};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createResourceNameValidator(res), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewPackageNameQuery(IScriptFolder pack, String initialSuggestedName) {
        Object[] keys = new String[]{pack.getElementName()};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageNameValidator(pack), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewProjectFragmentNameQuery(IProjectFragment root, String initialSuggestedName) {
        Object[] keys = new String[]{root.getElementName()};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createProjectFragmentNameValidator(root), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNullQuery() {
        return this.createStaticQuery(null);
    }

    public INewNameQuery createStaticQuery(final String newName) {
        return new INewNameQuery(){

            public String getNewName() {
                return newName;
            }
        };
    }

    private static INewNameQuery createStaticQuery(final IInputValidator validator, final String message, final String initial, final Shell shell) {
        return new INewNameQuery(){

            public String getNewName() {
                InputDialog dialog = new InputDialog(shell, ReorgMessages.ReorgQueries_nameConflictMessage, message, initial, validator){

                    protected Control createDialogArea(Composite parent) {
                        Control area = super.createDialogArea(parent);
                        TextFieldNavigationHandler.install(this.getText());
                        return area;
                    }
                };
                if (dialog.open() == 1) {
                    throw new OperationCanceledException();
                }
                return dialog.getValue();
            }
        };
    }

    private static IInputValidator createResourceNameValidator(final IResource res) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText) || res.getParent() == null) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (res.getParent().findMember(newText) != null) {
                    return ReorgMessages.ReorgQueries_resourceWithThisNameAlreadyExists;
                }
                if (!res.getParent().getFullPath().isValidSegment(newText)) {
                    return ReorgMessages.ReorgQueries_invalidNameMessage;
                }
                IStatus status = res.getParent().getWorkspace().validateName(newText, res.getType());
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                if (res.getName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createSourceModuleNameValidator(final ISourceModule cu) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                String newCuName = ScriptModelUtil.getRenamedCUName((ISourceModule)cu, (String)newText);
                IDLTKLanguageToolkit toolkit = null;
                toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)cu);
                Object status = new Status(4, "org.eclipse.dltk.ui", 0, ReorgMessages.NewNameQueries_mustBeAScriptProject, null);
                if (toolkit != null) {
                    status = DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)toolkit, (String)newCuName) ? IModelStatus.VERIFIED_OK : new Status(4, "org.eclipse.dltk.ui", ReorgMessages.NewNameQueries_invalidFileName);
                }
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                RefactoringStatus refStatus = Checks.checkSourceModuleNewName(cu, newText);
                if (refStatus.hasFatalError()) {
                    return refStatus.getMessageMatchingSeverity(4);
                }
                if (cu.getElementName().equalsIgnoreCase(newCuName)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createProjectFragmentNameValidator(IProjectFragment root) {
        return new IInputValidator(root){
            IInputValidator resourceNameValidator;
            {
                this.resourceNameValidator = NewNameQueries.createResourceNameValidator(iProjectFragment.getResource());
            }

            public String isValid(String newText) {
                return this.resourceNameValidator.isValid(newText);
            }
        };
    }

    private static IInputValidator createPackageNameValidator(final IScriptFolder pack) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                IModelElement parent = pack.getParent();
                if (parent instanceof IProjectFragment && DLTKCore.DEBUG) {
                    System.err.println("TODO:NewNamequeries add isPackageNameOkInRoot check...");
                }
                if (pack.getElementName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return validator;
    }
}

