/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.Predicate;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.utils.CompoundIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMemberQuery
implements Iterable<Member> {
    private final List<QueueItem> types = new ArrayList<QueueItem>();

    public TypeMemberQuery() {
    }

    public TypeMemberQuery(Type type) {
        this.add(type);
    }

    public TypeMemberQuery(Type type, Predicate<Member> predicate) {
        this.add(type, predicate);
    }

    public void add(Type type) {
        this.add(type, MemberPredicate.ALWAYS_TRUE);
    }

    public void add(Type type, Predicate<Member> predicate) {
        Assert.isNotNull((Object)type);
        this.types.add(new QueueItem(type, predicate));
    }

    protected boolean isValid(Type type) {
        return true;
    }

    @Override
    public Iterator<Member> iterator() {
        return new MemberIterator();
    }

    public Iterable<Member> ignoreDuplicates() {
        return this.ignoreDuplicates(null);
    }

    public Iterable<Member> ignoreDuplicates(final Collection<String> ignoreMembers) {
        return new Iterable<Member>(){

            @Override
            public Iterator<Member> iterator() {
                return new IgnoreDuplicateMemberIterator(ignoreMembers);
            }
        };
    }

    public Member findMember(String memberName) {
        for (Member member : this) {
            if (!memberName.equals(member.getName())) continue;
            return member;
        }
        return null;
    }

    public boolean contains(Type type) {
        for (QueueItem item : this.types) {
            if (type != item.type) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IgnoreDuplicateMemberIterator
    extends MemberIterator {
        private final Set<Object> processed;
        private final Collection<String> ignored;
        private List<Object> abstractMethods;

        public IgnoreDuplicateMemberIterator(Collection<String> ignoreMembers) {
            this.processed = new HashSet<Object>();
            this.abstractMethods = new ArrayList<Object>();
            this.ignored = ignoreMembers != null ? ignoreMembers : Collections.emptySet();
        }

        @Override
        protected boolean isValid(Member member) {
            if (super.isValid(member) && !this.ignored.contains(member.getName())) {
                Object key = MethodKey.createKey(member);
                if (member instanceof Method && ((Method)member).isAbstract()) {
                    if (!this.processed.contains(key)) {
                        this.abstractMethods.add(key);
                        this.abstractMethods.add(member);
                    }
                    return false;
                }
                return this.processed.add(key);
            }
            return false;
        }

        @Override
        protected boolean fetchNext() {
            boolean result = super.fetchNext();
            if (!result && !this.abstractMethods.isEmpty()) {
                ArrayList<Member> queue = new ArrayList<Member>();
                int i = 0;
                while (i < this.abstractMethods.size()) {
                    if (this.processed.add(this.abstractMethods.get(i))) {
                        queue.add((Member)this.abstractMethods.get(i + 1));
                    }
                    i += 2;
                }
                this.abstractMethods.clear();
                if (!queue.isEmpty()) {
                    this.current = queue.iterator();
                    return true;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemberIterator
    extends CompoundIterator<Member> {
        private final TypeIterator typeIterator;
        private final Set<Type> entrypoints = new HashSet<Type>();

        public MemberIterator() {
            for (QueueItem item : TypeMemberQuery.this.types) {
                this.entrypoints.add(item.type);
            }
            this.typeIterator = new TypeIterator();
            this.current = Collections.emptyList().iterator();
        }

        private Collection<Member> filter(Collection<Member> members) {
            ArrayList<Member> result = new ArrayList<Member>();
            for (Member member : members) {
                if (!this.isValid(member)) continue;
                result.add(member);
            }
            return result;
        }

        protected boolean isValid(Member member) {
            if (member.isStatic()) {
                Type owner = member.getDeclaringType();
                return owner != null && (owner.isInheritStaticMembers() || this.entrypoints.contains(owner));
            }
            return true;
        }

        protected boolean fetchNext() {
            while (this.typeIterator.hasNext()) {
                QueueItem item = (QueueItem)this.typeIterator.next();
                if (item.predicate == MemberPredicate.ALWAYS_TRUE) {
                    this.current = this.filter((Collection<Member>)item.type.getMembers()).iterator();
                } else {
                    ArrayList<Member> filtered = new ArrayList<Member>(item.type.getMembers().size());
                    for (Member member : item.type.getMembers()) {
                        if (!item.predicate.evaluate((Object)member)) continue;
                        filtered.add(member);
                    }
                    this.current = this.filter(filtered).iterator();
                }
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    private static class MemberKey {
        final String name;
        final boolean isStatic;

        public MemberKey(Member member) {
            this.name = member.getName();
            this.isStatic = member.isStatic();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberKey) {
                MemberKey other = (MemberKey)obj;
                return this.name.equals(other.name) && this.isStatic == other.isStatic;
            }
            return false;
        }
    }

    private static class MethodKey {
        final String name;
        final boolean isStatic;
        final String signature;

        public MethodKey(Method method) {
            this.name = method.getName();
            this.isStatic = method.isStatic();
            StringBuilder sb = new StringBuilder();
            for (Parameter parameter : method.getParameters()) {
                JSType paramType = parameter.getType();
                if (paramType != null) {
                    sb.append(paramType.getName());
                }
                sb.append(',');
            }
            this.signature = sb.toString();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey other = (MethodKey)obj;
                return this.name.equals(other.name) && this.isStatic == other.isStatic && this.signature.equals(other.signature);
            }
            return false;
        }

        protected static Object createKey(Member member) {
            if (member instanceof Method && member.getDeclaringType() != null && member.getDeclaringType().getKind() == TypeKind.JAVA) {
                return new MethodKey((Method)member);
            }
            return new MemberKey(member);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueueItem {
        final Type type;
        final Predicate<Member> predicate;

        public QueueItem(Type type, Predicate<Member> predicate) {
            this.type = type;
            this.predicate = predicate;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueueItem) {
                QueueItem other = (QueueItem)obj;
                return this.type.equals(other.type) && this.predicate.equals(other.predicate);
            }
            return false;
        }

        public String toString() {
            return this.predicate + ":" + this.type.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeIterator
    extends CompoundIterator<QueueItem> {
        private final Set<QueueItem> visited = new HashSet<QueueItem>();
        private final List<QueueItem> queue = new ArrayList<QueueItem>();

        public TypeIterator() {
            this.queue.addAll(TypeMemberQuery.this.types);
            this.current = this.queue.iterator();
        }

        private boolean canVisit(QueueItem item) {
            return this.visited.add(item);
        }

        protected boolean fetchNext() {
            if (!this.queue.isEmpty()) {
                QueueItem[] copy = this.queue.toArray(new QueueItem[this.queue.size()]);
                this.queue.clear();
                QueueItem[] queueItemArray = copy;
                int n = copy.length;
                int n2 = 0;
                while (n2 < n) {
                    QueueItem superItem;
                    QueueItem item = queueItemArray[n2];
                    Type type = item.type;
                    Type superType = type.getSuperType();
                    if (superType != null && this.canVisit(superItem = new QueueItem(superType, item.predicate)) && TypeMemberQuery.this.isValid(superType)) {
                        this.queue.add(superItem);
                    }
                    for (Type trait : type.getTraits()) {
                        QueueItem traitItem = new QueueItem(trait, item.predicate);
                        if (!this.canVisit(traitItem) || !TypeMemberQuery.this.isValid(trait)) continue;
                        this.queue.add(traitItem);
                    }
                    ++n2;
                }
                this.current = this.queue.iterator();
                return this.current.hasNext();
            }
            return false;
        }
    }
}

