/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRElement;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRVariable;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RModelBuilder {
    public static IRMethod create(ITypeSystem context, IModelBuilder.IMethod method) {
        return new RMethod(method.getName(), JSTypeSet.normalize(context, method.getType()), method.getLocation(), method.getSuppressedWarnings(), method.isDeprecated(), method.getVisibility(), method.isConstructor(), RModelBuilder.convertParams0(context, method.getParameters()));
    }

    public static IRVariable create(ITypeSystem context, IModelBuilder.IVariable variable) {
        return new RVariable(variable.getName(), JSTypeSet.normalize(context, variable.getType()), variable.getLocation(), variable.getSuppressedWarnings(), variable.isDeprecated(), variable.getVisibility());
    }

    public static List<IRParameter> convert(ITypeSystem context, List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IRParameter> params = new ArrayList<IRParameter>();
        for (Parameter parameter : parameters) {
            IRType paramType = parameter.getType() != null ? JSTypeSet.normalize(context, parameter.getType()) : JSTypeSet.any();
            params.add(new RParameter(parameter.getName(), paramType, parameter.getKind()));
        }
        return params;
    }

    private static List<IRParameter> convertParams0(ITypeSystem context, List<IModelBuilder.IParameter> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IRParameter> params = new ArrayList<IRParameter>();
        for (IModelBuilder.IParameter parameter : parameters) {
            IRType paramType;
            IRType iRType = paramType = parameter.getType() != null ? JSTypeSet.normalize(context, parameter.getType()) : JSTypeSet.any();
            ParameterKind kind = parameter.isVarargs() ? ParameterKind.VARARGS : (parameter.isOptional() ? ParameterKind.OPTIONAL : ParameterKind.NORMAL);
            params.add(new RParameter(parameter.getName(), paramType, kind));
        }
        return params;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RElement
    implements IRElement {
        private final String name;
        protected final IRType type;
        private final ReferenceLocation location;
        private final Set<IProblemCategory> suppressedWarnings;

        public RElement(String name, IRType type, ReferenceLocation location, Set<IProblemCategory> suppressedWarnings) {
            this.name = name;
            this.type = type;
            this.location = location;
            this.suppressedWarnings = suppressedWarnings;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IRType getType() {
            return this.type;
        }

        @Override
        public ReferenceLocation getLocation() {
            return this.location;
        }

        @Override
        public Set<IProblemCategory> getSuppressedWarnings() {
            return this.suppressedWarnings != null ? this.suppressedWarnings : Collections.emptySet();
        }

        @Override
        public boolean isSuppressed(IProblemIdentifier problemIdentifier) {
            if (this.suppressedWarnings != null) {
                for (IProblemCategory category : this.suppressedWarnings) {
                    if (!category.contents().contains(problemIdentifier)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RMember
    extends RElement
    implements IRMember {
        final boolean _deprecated;
        final Visibility visibility;

        public RMember(String name, IRType type, ReferenceLocation location, Set<IProblemCategory> suppressedWarnings, boolean _deprecated, Visibility visibility) {
            super(name, type, location, suppressedWarnings);
            this._deprecated = _deprecated;
            this.visibility = visibility;
        }

        @Override
        public boolean isDeprecated() {
            return this._deprecated;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public boolean isPrivate() {
            return this.visibility == Visibility.PRIVATE;
        }

        @Override
        public boolean isProtected() {
            return this.visibility == Visibility.PROTECTED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RMethod
    extends RMember
    implements IRMethod {
        final boolean _constructor;
        final List<IRParameter> parameters;

        public RMethod(String name, IRType type, ReferenceLocation location, Set<IProblemCategory> suppressedWarnings, boolean _deprecated, Visibility visibility, boolean _constructor, List<IRParameter> parameters) {
            super(name, type, location, suppressedWarnings, _deprecated, visibility);
            this._constructor = _constructor;
            this.parameters = parameters;
        }

        @Override
        public int getParameterCount() {
            return this.parameters.size();
        }

        @Override
        public List<IRParameter> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isTyped() {
            if (this.type != null) {
                return true;
            }
            int i = 0;
            while (i < this.parameters.size()) {
                IRParameter parameter = this.parameters.get(i);
                if (parameter.getType() != JSTypeSet.any() || parameter.getKind() != ParameterKind.NORMAL) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean isConstructor() {
            return this._constructor;
        }
    }

    private static class RParameter
    implements IRParameter {
        private final String name;
        private final IRType type;
        private final ParameterKind kind;

        public RParameter(String name, IRType type, ParameterKind kind) {
            Assert.isNotNull((Object)type);
            this.name = name;
            this.type = type;
            this.kind = kind;
        }

        public String getName() {
            return this.name;
        }

        public IRType getType() {
            return this.type;
        }

        public ParameterKind getKind() {
            return this.kind;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RParameter) {
                RParameter other = (RParameter)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                if (!this.type.equals(other.type)) {
                    return false;
                }
                return this.kind == other.kind;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.name) + ":" + this.type;
        }

        public boolean isOptional() {
            return this.kind == ParameterKind.OPTIONAL;
        }

        public boolean isVarargs() {
            return this.kind == ParameterKind.VARARGS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RVariable
    extends RMember
    implements IRVariable {
        public RVariable(String name, IRType type, ReferenceLocation location, Set<IProblemCategory> suppressedWarnings, boolean _deprecated, Visibility visibility) {
            super(name, type, location, suppressedWarnings, _deprecated, visibility);
        }
    }
}

